/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.unit.data;

import com.astamuse.asta4d.data.convertor.String2Date;
import com.astamuse.asta4d.data.convertor.String2Java8Instant;
import com.astamuse.asta4d.data.convertor.String2Java8LocalDateTime;
import com.astamuse.asta4d.data.convertor.String2Java8LocalTime;
import com.astamuse.asta4d.data.convertor.String2Java8YearMonth;
import com.astamuse.asta4d.data.convertor.String2JodaDateTime;
import com.astamuse.asta4d.data.convertor.String2JodaLocalDate;
import com.astamuse.asta4d.data.convertor.String2JodaLocalDateTime;
import com.astamuse.asta4d.data.convertor.String2JodaLocalTime;
import com.astamuse.asta4d.data.convertor.String2JodaYearMonth;
import java.time.Instant;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test
public class DateValueConvertorTest {
    @DataProvider(name="string2Date")
    Object[][] string2DateData() {
        return new Object[][]{{"2014-10-23T12:00:23.000+1100", new Date(114, 9, 23, 12, 0, 23), DateTimeZone.forOffsetHours((int)11)}, {"2014-10-23T12:00:23.000", new Date(114, 9, 23, 12, 0, 23), null}, {"2014-10-23T12:00:23", new Date(114, 9, 23, 12, 0, 23), null}, {"2014-10-23", new Date(114, 9, 23, 0, 0, 0), null}, {"20141023T120023.000-0900", new Date(114, 9, 23, 12, 0, 23), DateTimeZone.forOffsetHours((int)-9)}, {"20141023T120023.000", new Date(114, 9, 23, 12, 0, 23), null}, {"20141023T120023", new Date(114, 9, 23, 12, 0, 23), null}, {"20141023", new Date(114, 9, 23, 0, 0, 0), null}, {"", null, null}};
    }

    @Test(dataProvider="string2Date")
    public void testString2Date(String s, Date d, DateTimeZone tz) throws Exception {
        String2Date convertor = new String2Date();
        if (tz == null) {
            Assert.assertEquals((Object)convertor.convert(s), (Object)d);
        } else {
            long expectedTimeGMT = d.getTime();
            Date actualDate = (Date)convertor.convert(s);
            Assert.assertEquals((Object)actualDate, (Object)new Date(expectedTimeGMT += (long)(DateTimeZone.getDefault().toTimeZone().getRawOffset() - tz.toTimeZone().getRawOffset())));
        }
    }

    @Test(dataProvider="string2Date")
    public void testString2JodaDateTime(String s, Date d, DateTimeZone tz) throws Exception {
        String2JodaDateTime convertor = new String2JodaDateTime();
        if (d == null) {
            Assert.assertEquals((Object)convertor.convert(s), null);
        } else if (tz == null) {
            Assert.assertEquals((Object)convertor.convert(s), (Object)new DateTime(d.getTime()));
        } else {
            long expectedTimeGMT = d.getTime();
            DateTime actualDate = (DateTime)convertor.convert(s);
            Assert.assertEquals((Object)actualDate, (Object)new DateTime(expectedTimeGMT += (long)(DateTimeZone.getDefault().toTimeZone().getRawOffset() - tz.toTimeZone().getRawOffset())));
        }
    }

    @Test(dataProvider="string2Date")
    public void testString2Java8Instant(String s, Date d, DateTimeZone tz) throws Exception {
        String2Java8Instant convertor = new String2Java8Instant();
        Instant acturalInstant = (Instant)convertor.convert(s);
        if (d == null) {
            Assert.assertEquals((Object)acturalInstant, null);
        } else if (tz == null) {
            long expectedTimeGMT = d.getTime();
            Assert.assertEquals((Object)acturalInstant, (Object)Instant.ofEpochMilli(expectedTimeGMT));
        } else {
            long expectedTimeGMT = d.getTime();
            Assert.assertEquals((Object)acturalInstant, (Object)Instant.ofEpochMilli(expectedTimeGMT += (long)(DateTimeZone.getDefault().toTimeZone().getRawOffset() - tz.toTimeZone().getRawOffset())));
        }
    }

    @Test(dataProvider="string2Date")
    public void testString2JodaLocalDate(String s, Date d, DateTimeZone tz) throws Exception {
        String2JodaLocalDate convertor = new String2JodaLocalDate();
        if (d == null) {
            Assert.assertEquals((Object)convertor.convert(s), null);
        } else {
            Assert.assertEquals((Object)convertor.convert(s), (Object)new LocalDate(d.getTime()));
        }
    }

    @Test(dataProvider="string2Date")
    public void testString2JodaLocalDateTime(String s, Date d, DateTimeZone tz) throws Exception {
        String2JodaLocalDateTime convertor = new String2JodaLocalDateTime();
        if (d == null) {
            Assert.assertEquals((Object)convertor.convert(s), null);
        } else {
            Assert.assertEquals((Object)convertor.convert(s), (Object)new LocalDateTime(d.getTime()));
        }
    }

    @Test(dataProvider="string2Date")
    public void testString2Java8LocalDateTime(String s, Date d, DateTimeZone tz) throws Exception {
        String2Java8LocalDateTime convertor = new String2Java8LocalDateTime();
        if (d == null) {
            Assert.assertEquals((Object)convertor.convert(s), null);
        } else {
            long expectedTimeGMT = d.getTime();
            Assert.assertEquals((Object)convertor.convert(s), (Object)java.time.LocalDateTime.ofEpochSecond((expectedTimeGMT += (long)DateTimeZone.getDefault().toTimeZone().getRawOffset()) / 1000L, 0, ZoneOffset.UTC));
        }
    }

    @DataProvider(name="string2Time")
    Object[][] string2TimeData() {
        return new Object[][]{{"12:00:23.000+1100", LocalTime.parse((String)"12:00:23")}, {"12:00:23.000", LocalTime.parse((String)"12:00:23")}, {"12:00:23", LocalTime.parse((String)"12:00:23")}, {"120023.000-0900", LocalTime.parse((String)"12:00:23")}, {"120023.000", LocalTime.parse((String)"12:00:23")}, {"120023", LocalTime.parse((String)"12:00:23")}};
    }

    @Test(dataProvider="string2Time")
    public void testString2JodaLocalTime(String s, LocalTime t) throws Exception {
        String2JodaLocalTime convertor = new String2JodaLocalTime();
        Assert.assertEquals((Object)convertor.convert(s), (Object)t);
    }

    @Test(dataProvider="string2Time")
    public void testString2Java8LocalTime(String s, LocalTime t) throws Exception {
        String2Java8LocalTime convertor = new String2Java8LocalTime();
        java.time.LocalTime jlt = java.time.LocalTime.ofNanoOfDay((long)t.getMillisOfDay() * 1000L * 1000L);
        Assert.assertEquals((Object)convertor.convert(s), (Object)jlt);
    }

    @DataProvider(name="string2ym")
    Object[][] string2ymData() {
        return new Object[][]{{"2014-10", org.joda.time.YearMonth.parse((String)"2014-10")}, {"201410", org.joda.time.YearMonth.parse((String)"2014-10")}};
    }

    @Test(dataProvider="string2ym")
    public void testString2JodaYearMonth(String s, org.joda.time.YearMonth ym) throws Exception {
        String2JodaYearMonth convertor = new String2JodaYearMonth();
        Assert.assertEquals((Object)convertor.convert(s), (Object)ym);
    }

    @Test(dataProvider="string2ym")
    public void testString2Java8YearMonth(String s, org.joda.time.YearMonth ym) throws Exception {
        String2Java8YearMonth convertor = new String2Java8YearMonth();
        Assert.assertEquals((Object)convertor.convert(s), (Object)YearMonth.of(ym.getYear(), ym.getMonthOfYear()));
    }
}

