/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.unit;

import com.astamuse.asta4d.template.AbstractTemplateResolver;
import com.astamuse.asta4d.template.Template;
import com.astamuse.asta4d.template.TemplateException;
import com.astamuse.asta4d.template.TemplateNotFoundException;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TemplateResolverTest
extends BaseTest {
    @Test(expectedExceptions={TemplateNotFoundException.class})
    public void templateNotFoundTest() throws TemplateException, TemplateNotFoundException {
        AbstractTemplateResolver resolver = new AbstractTemplateResolver(){

            protected AbstractTemplateResolver.TemplateInfo loadResource(String name) {
                return null;
            }
        };
        Template template = resolver.findTemplate("test");
    }

    private static InputStream createInputStream(String bodyContent) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>").append(bodyContent).append("</body></html>");
        ByteArrayInputStream bis = new ByteArrayInputStream(sb.toString().getBytes());
        return bis;
    }

    public void templateCacheNonStatic() throws TemplateException, TemplateNotFoundException {
        AbstractTemplateResolver resolver1 = new AbstractTemplateResolver(){

            protected AbstractTemplateResolver.TemplateInfo loadResource(String name) {
                return new AbstractTemplateResolver.TemplateInfo("p1", TemplateResolverTest.createInputStream("p1"));
            }
        };
        AbstractTemplateResolver resolver2 = new AbstractTemplateResolver(){

            protected AbstractTemplateResolver.TemplateInfo loadResource(String name) {
                return new AbstractTemplateResolver.TemplateInfo("p2", TemplateResolverTest.createInputStream("p2"));
            }
        };
        Template template1 = resolver1.findTemplate("pp");
        Template template2 = resolver2.findTemplate("pp");
        Assert.assertNotSame((Object)template1, (Object)template2);
        Assert.assertNotEquals((Object)template1.getPath(), (Object)template2.getPath(), (String)"should be different template path");
    }
}

