/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.unit;

import com.astamuse.asta4d.Context;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import com.astamuse.asta4d.util.i18n.I18nMessageHelper;
import com.astamuse.asta4d.util.i18n.MappedParamI18nMessageHelper;
import com.astamuse.asta4d.util.i18n.OrderedParamI18nMessageHelper;
import com.astamuse.asta4d.util.i18n.formatter.ApacheStrSubstitutorFormatter;
import com.astamuse.asta4d.util.i18n.formatter.JDKMessageFormatFormatter;
import com.astamuse.asta4d.util.i18n.formatter.MappedValueFormatter;
import com.astamuse.asta4d.util.i18n.formatter.OrderedValueFormatter;
import com.astamuse.asta4d.util.i18n.formatter.SymbolPlaceholderFormatter;
import com.astamuse.asta4d.util.i18n.pattern.CharsetResourceBundleFactory;
import com.astamuse.asta4d.util.i18n.pattern.JDKResourceBundleMessagePatternRetriever;
import com.astamuse.asta4d.util.i18n.pattern.LatinEscapingResourceBundleFactory;
import com.astamuse.asta4d.util.i18n.pattern.ResourceBundleFactory;
import java.util.HashMap;
import java.util.Locale;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test
public class ResourceBundleUtilTest
extends BaseTest {
    @BeforeClass
    public void setDefaultLocale() {
        Locale.setDefault(Locale.ROOT);
    }

    @Test
    public void useSymbolFormatter() throws Exception {
        OrderedParamI18nMessageHelper helper = new OrderedParamI18nMessageHelper((OrderedValueFormatter)new SymbolPlaceholderFormatter());
        this.setUp((I18nMessageHelper)helper, "symbol_placeholder_messages");
        Assert.assertEquals((String)helper.getMessage("weatherreport1", new Object[]{"Tomorrow", "sunny"}), (String)"Tomorrow's weather is sunny.");
    }

    @Test
    public void useSymbolFormatterJaJp() throws Exception {
        OrderedParamI18nMessageHelper helper = new OrderedParamI18nMessageHelper((OrderedValueFormatter)new SymbolPlaceholderFormatter());
        this.setUp((I18nMessageHelper)helper, "symbol_placeholder_messages");
        Assert.assertEquals((String)helper.getMessage(Locale.JAPAN, "weatherreport1", new Object[]{"\u660e\u65e5", "\u6674\u308c"}), (String)"\u660e\u65e5\u306e\u5929\u6c17\u306f\u6674\u308c\u3067\u3059\u3002");
    }

    @Test
    public void useNumberFormatter() throws Exception {
        OrderedParamI18nMessageHelper helper = new OrderedParamI18nMessageHelper((OrderedValueFormatter)new JDKMessageFormatFormatter());
        this.setUp((I18nMessageHelper)helper, "number_placeholder_messages");
        Assert.assertEquals((String)helper.getMessage("weatherreport1", new Object[]{"Tomorrow", "sunny"}), (String)"Tomorrow's weather is sunny.");
    }

    @Test
    public void useNumberFormatterJaJp() throws Exception {
        OrderedParamI18nMessageHelper helper = new OrderedParamI18nMessageHelper((OrderedValueFormatter)new JDKMessageFormatFormatter());
        this.setUp((I18nMessageHelper)helper, "number_placeholder_messages");
        Assert.assertEquals((String)helper.getMessage(Locale.JAPAN, "weatherreport1", new Object[]{"\u660e\u65e5", "\u6674\u308c"}), (String)"\u660e\u65e5\u306e\u5929\u6c17\u306f\u6674\u308c\u3067\u3059\u3002");
    }

    @Test
    public void useNamedFormatter() throws Exception {
        MappedParamI18nMessageHelper helper = new MappedParamI18nMessageHelper((MappedValueFormatter)new ApacheStrSubstitutorFormatter());
        this.setUp((I18nMessageHelper)helper, "named_placeholder_messages");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("date", "Tomorrow");
        params.put("weather", "sunny");
        Assert.assertEquals((String)helper.getMessage("weatherreport1", params), (String)"Tomorrow's weather is sunny.");
    }

    @Test
    public void useNamedFormatterWithSplittedMessagePattern() throws Exception {
        MappedParamI18nMessageHelper helper = new MappedParamI18nMessageHelper((MappedValueFormatter)new ApacheStrSubstitutorFormatter());
        this.setUp((I18nMessageHelper)helper, "named_placeholder_messages");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("date", "Tomorrow");
        params.put("weather", "sunny");
        Assert.assertEquals((String)helper.getMessage("weatherreport-split", params), (String)"Tomorrow's weather is sunny.");
    }

    @Test
    public void useNamedFormatterJaJp() throws Exception {
        MappedParamI18nMessageHelper helper = new MappedParamI18nMessageHelper((MappedValueFormatter)new ApacheStrSubstitutorFormatter());
        this.setUp((I18nMessageHelper)helper, "named_placeholder_messages");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("date", "\u660e\u65e5");
        params.put("weather", "\u6674\u308c");
        Assert.assertEquals((String)helper.getMessage(Locale.JAPAN, "weatherreport1", params), (String)"\u660e\u65e5\u306e\u5929\u6c17\u306f\u6674\u308c\u3067\u3059\u3002");
    }

    @Test
    public void utf8MessageFileJaJp() throws Exception {
        MappedParamI18nMessageHelper helper = new MappedParamI18nMessageHelper((MappedValueFormatter)new ApacheStrSubstitutorFormatter());
        this.setUp((I18nMessageHelper)helper, "utf_8_messages");
        ((JDKResourceBundleMessagePatternRetriever)helper.getMessagePatternRetriever()).setResourceBundleFactory((ResourceBundleFactory)new CharsetResourceBundleFactory("UTF-8"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("date", "\u660e\u65e5");
        params.put("weather", "\u6674\u308c");
        Assert.assertEquals((String)helper.getMessage(Locale.JAPAN, "weatherreport", params), (String)"\u660e\u65e5\u306e\u5929\u6c17\u306f\u6674\u308c\u3067\u3059\u3002");
    }

    private void setUp(I18nMessageHelper helper, String fileName) {
        Context context = Context.getCurrentThreadContext();
        context.setCurrentLocale(Locale.US);
        JDKResourceBundleMessagePatternRetriever retriever = (JDKResourceBundleMessagePatternRetriever)helper.getMessagePatternRetriever();
        retriever.setResourceNames(new String[]{"com.astamuse.asta4d.test.render.messages." + fileName});
        retriever.setResourceBundleFactory((ResourceBundleFactory)new LatinEscapingResourceBundleFactory());
    }
}

