/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.unit;

import com.astamuse.asta4d.render.ChildReplacer;
import com.astamuse.asta4d.render.ElementSetter;
import com.astamuse.asta4d.render.Renderable;
import com.astamuse.asta4d.render.Renderer;
import com.astamuse.asta4d.render.SpecialRenderer;
import com.astamuse.asta4d.render.test.RendererTestException;
import com.astamuse.asta4d.render.test.RendererTester;
import com.astamuse.asta4d.render.test.TestableElementWrapper;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import com.astamuse.asta4d.util.ElementUtil;
import com.astamuse.asta4d.util.collection.RowConvertor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.jsoup.nodes.Element;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RenderTesterTest
extends BaseTest {
    @Test
    public void testGetSingle() {
        Renderer render = Renderer.create();
        render.add("#someIdForInt", Integer.valueOf(12345));
        render.add("#someIdForLong", Long.valueOf(12345L));
        render.add("#someIdForBool", Boolean.valueOf(true));
        render.add("#someIdForStr", "a str");
        render.add("#someIdForNull", null);
        render.add("#someIdForClear", SpecialRenderer.Clear);
        Element newChild = ElementUtil.parseAsSingle((String)"<div></div>");
        render.add("#someIdForElementSetter", (ElementSetter)new ChildReplacer(newChild));
        render.add("#someIdForElement", ElementUtil.parseAsSingle((String)"<div>eee</div>"));
        render.add("#someIdForRenderer", Renderer.create((String)"#value", (String)"value"));
        render.add("#someIdForRendable", () -> Renderer.create((String)"#id", (String)"xx"));
        RendererTester tester = RendererTester.forRenderer((Renderer)render);
        Assert.assertFalse((boolean)tester.noOp());
        Assert.assertEquals((Object)tester.get("#someIdForInt"), (Object)12345);
        Assert.assertEquals((Object)tester.get("#someIdForLong"), (Object)12345L);
        Assert.assertEquals((Object)tester.get("#someIdForBool"), (Object)true);
        Assert.assertEquals((Object)tester.get("#someIdForStr"), (Object)"a str");
        Assert.assertEquals((Object)tester.get("#someIdForNull"), null);
        Assert.assertEquals((Object)tester.get("#someIdForClear"), (Object)SpecialRenderer.Clear);
        Assert.assertFalse((boolean)tester.noOp("#someIdForClear"));
        Assert.assertTrue((boolean)tester.noOp("#notexistop"));
        Assert.assertEquals((Object)tester.get("#someIdForElementSetter"), (Object)new ChildReplacer(ElementUtil.parseAsSingle((String)"<div></div>")));
        Assert.assertEquals((Object)tester.get("#someIdForElement"), (Object)TestableElementWrapper.parse((String)"<div>eee</div>"));
        RendererTester recursiveTester = RendererTester.forRenderer((Renderer)((Renderer)tester.get("#someIdForRenderer")));
        Assert.assertEquals((Object)recursiveTester.get("#value"), (Object)"value");
        recursiveTester = RendererTester.forRenderer((Renderer)((Renderable)tester.get("#someIdForRendable")).render());
        Assert.assertEquals((Object)recursiveTester.get("#id"), (Object)"xx");
        tester = RendererTester.forRenderer((Renderer)Renderer.create());
        Assert.assertTrue((boolean)tester.noOp());
    }

    @Test(expectedExceptions={RendererTestException.class}, expectedExceptionsMessageRegExp="There is no value to be rendered for selector(.*)")
    public void testGetSingleNotFound() {
        Renderer render = Renderer.create();
        render.add("#someId", Integer.valueOf(12345));
        RendererTester tester = RendererTester.forRenderer((Renderer)render);
        Assert.assertEquals((Object)tester.get("#someIdNotExist"), (Object)12345);
    }

    @Test(expectedExceptions={RendererTestException.class}, expectedExceptionsMessageRegExp="(.*)as a list(.*)")
    public void testGetSingleFoundMore() {
        Renderer render = Renderer.create();
        render.add("#someId", Arrays.asList(123, 345));
        RendererTester tester = RendererTester.forRenderer((Renderer)render);
        Assert.assertEquals((Object)tester.get("#someId"), (Object)123);
    }

    @Test(expectedExceptions={RendererTestException.class}, expectedExceptionsMessageRegExp="(.*)as a empty list(.*)")
    public void testGetSingleFoundMore2() {
        Renderer render = Renderer.create();
        render.add("#someId", Collections.emptyList());
        RendererTester tester = RendererTester.forRenderer((Renderer)render);
        Assert.assertEquals((Object)tester.get("#someId"), (Object)123);
    }

    @Test(expectedExceptions={RendererTestException.class}, expectedExceptionsMessageRegExp="(.*)multiple times(.*)")
    public void testGetSingleFoundMore3() {
        Renderer render = Renderer.create();
        render.add("#someId", Integer.valueOf(123));
        render.add("#someId", Integer.valueOf(345));
        RendererTester tester = RendererTester.forRenderer((Renderer)render);
        Assert.assertEquals((Object)tester.get("#someId"), (Object)123);
    }

    @Test
    public void testGetList() {
        Renderer render = Renderer.create();
        render.add("#someIdForInt", Arrays.asList(123, 456, 789));
        render.add("#someIdForLong", Arrays.asList(123L, 456L, 789L));
        render.add("#someIdForBool", Arrays.asList(true, true, false));
        render.add("#someIdForStr", Arrays.asList("str1", "str2", "str3"));
        Element newChild1 = ElementUtil.parseAsSingle((String)"<div>1</div>");
        Element newChild2 = ElementUtil.parseAsSingle((String)"<div>2</div>");
        render.add("#someIdForElementSetter", Arrays.asList(new ChildReplacer(newChild1), new ChildReplacer(newChild2)));
        render.add("#someIdForElement", Arrays.asList(newChild1, newChild2));
        RendererTester tester = RendererTester.forRenderer((Renderer)render);
        Assert.assertEquals((Collection)tester.getAsList("#someIdForInt"), Arrays.asList(123, 456, 789));
        Assert.assertEquals((Collection)tester.getAsList("#someIdForLong"), Arrays.asList(123L, 456L, 789L));
        Assert.assertEquals((Collection)tester.getAsList("#someIdForBool"), Arrays.asList(true, true, false));
        Assert.assertEquals((Collection)tester.getAsList("#someIdForStr"), Arrays.asList("str1", "str2", "str3"));
        Assert.assertEquals((Collection)tester.getAsList("#someIdForElementSetter"), Arrays.asList(new ChildReplacer(ElementUtil.parseAsSingle((String)"<div>1</div>")), new ChildReplacer(ElementUtil.parseAsSingle((String)"<div>2</div>"))));
        Assert.assertEquals((Collection)tester.getAsList("#someIdForElement"), Arrays.asList(TestableElementWrapper.parse((String)"<div>1</div>"), TestableElementWrapper.parse((String)"<div>2</div>")));
    }

    @Test
    public void testGetListAsRenderer() {
        Renderer render = Renderer.create();
        render.add("#someIdForRenderer", Arrays.asList(123, 456, 789), (RowConvertor)new RowConvertor<Integer, Renderer>(){

            public Renderer convert(int rowIndex, Integer obj) {
                return Renderer.create((String)"#id", (String)("id-" + obj)).add("#otherId", "otherId-" + obj);
            }
        });
        render.add("#someIdForStream", Arrays.asList(123, 456, 789).stream().map(i -> Renderer.create((String)"#id", (String)("id-" + i)).add("#otherId", "otherId-" + i)));
        RendererTester tester = RendererTester.forRenderer((Renderer)render);
        for (String selector : Arrays.asList("#someIdForRenderer", "#someIdForStream")) {
            List testerList = tester.getAsRendererTesterList(selector);
            List<String> confirmIdList = Arrays.asList("id-123", "id-456", "id-789");
            Assert.assertEquals((int)testerList.size(), (int)3);
            for (int i2 = 0; i2 < testerList.size(); ++i2) {
                RendererTester recursiveTester = (RendererTester)testerList.get(i2);
                Assert.assertEquals((Object)recursiveTester.get("#id"), (Object)confirmIdList.get(i2));
            }
            List<String> confirmOtherIdList = Arrays.asList("otherId-123", "otherId-456", "otherId-789");
            List testerList2 = tester.getAsRendererTesterList(selector);
            Assert.assertEquals((Collection)testerList2.stream().map(t -> t.get("#otherId")).collect(Collectors.toList()), confirmOtherIdList);
        }
    }

    @Test
    public void testGetAttr() {
        Renderer render = Renderer.create();
        render.add("#id", "+class", "yyy");
        render.add("#id", "-class", "zzz");
        render.add("#id", "+class", "xxx");
        render.add("#id", "value", (Object)new Date(123456L));
        render.add("#id", "href", null);
        render.add("#idstr", "value", "hg");
        render.add("#idint", "value", Integer.valueOf(3));
        render.add("#idlong", "value", Long.valueOf(3L));
        render.add("#idbool", "value", Boolean.valueOf(true));
        RendererTester tester = RendererTester.forRenderer((Renderer)render);
        Assert.assertEquals((Collection)tester.getAttrAsList("#id", "+class"), Arrays.asList("yyy", "xxx"));
        Assert.assertEquals((Object)tester.getAttr("#id", "-class"), (Object)"zzz");
        Assert.assertEquals((Object)tester.getAttr("#id", "value"), (Object)new Date(123456L));
        Assert.assertEquals((Object)tester.getAttr("#id", "href"), null);
        Assert.assertEquals((Object)tester.getAttr("#idstr", "value"), (Object)"hg");
        Assert.assertEquals((Object)tester.getAttr("#idint", "value"), (Object)"3");
        Assert.assertEquals((Object)tester.getAttr("#idlong", "value"), (Object)"3");
        Assert.assertEquals((Object)tester.getAttr("#idbool", "value"), (Object)"true");
        Assert.assertFalse((boolean)tester.noOp("#id", "+class"));
        Assert.assertFalse((boolean)tester.noOp("#id", "-class"));
        Assert.assertFalse((boolean)tester.noOp("#id", "value"));
        Assert.assertFalse((boolean)tester.noOp("#id", "href"));
        Assert.assertFalse((boolean)tester.noOp("#idstr", "value"));
        Assert.assertFalse((boolean)tester.noOp("#idint", "value"));
        Assert.assertFalse((boolean)tester.noOp("#idlong", "value"));
        Assert.assertFalse((boolean)tester.noOp("#idbool", "value"));
        Assert.assertTrue((boolean)tester.noOp("#id", "+cccc"));
        Assert.assertTrue((boolean)tester.noOp("#id", "-cccc"));
        Assert.assertTrue((boolean)tester.noOp("#id", "cccc"));
    }

    @Test(expectedExceptions={RendererTestException.class}, expectedExceptionsMessageRegExp="There is no value to be rendered for attr(.*)")
    public void testGetAttrNotFound() {
        Renderer render = Renderer.create();
        render.add("#id", "+class", "yyy");
        RendererTester tester = RendererTester.forRenderer((Renderer)render);
        Assert.assertEquals((Object)tester.getAttr("#id", "href"), null);
    }

    @Test(expectedExceptions={RendererTestException.class}, expectedExceptionsMessageRegExp="(.*)more than one values(.*)")
    public void testGetAttrFindMore() {
        Renderer render = Renderer.create();
        render.add("#id", "value", "yyy");
        render.add("#id", "value", "zzz");
        RendererTester tester = RendererTester.forRenderer((Renderer)render);
        Assert.assertEquals((Object)tester.getAttr("#id", "value"), (Object)"zzz");
    }

    @Test(expectedExceptions={RendererTestException.class}, expectedExceptionsMessageRegExp="This method is only for retrieving rendered value of \"\\+class\" and \"\\-class\" attr action")
    public void testGetAttrFindMore2() {
        Renderer render = Renderer.create();
        render.add("#id", "value", "yyy");
        render.add("#id", "value", "zzz");
        RendererTester tester = RendererTester.forRenderer((Renderer)render);
        Assert.assertEquals((Collection)tester.getAttrAsList("#id", "value"), Arrays.asList("yyy", "zzz"));
    }
}

