/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.unit;

import com.astamuse.asta4d.Configuration;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import com.astamuse.asta4d.util.collection.ListConvertUtil;
import com.astamuse.asta4d.util.collection.ParallelRecursivePolicy;
import com.astamuse.asta4d.util.collection.RowConvertor;
import com.astamuse.asta4d.util.collection.RowConvertorBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ParallelListConvertingTest
extends BaseTest {
    @BeforeClass
    public void setDefaultLocale() {
        Locale.setDefault(Locale.ROOT);
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp=".*Recursive parallel list converting is forbidden.*")
    public void testForException() {
        this.tryConvert(ParallelRecursivePolicy.EXCEPTION);
    }

    @Test
    public void testForCurrentThread() {
        this.tryConvert(ParallelRecursivePolicy.CURRENT_THREAD);
    }

    @Test
    public void testForNewThread() {
        this.tryConvert(ParallelRecursivePolicy.NEW_THREAD);
    }

    private void tryConvert(final ParallelRecursivePolicy policy) {
        Configuration.getConfiguration().setRecursivePolicyForParallelListConverting(policy);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        ListConvertUtil.transform(list, (RowConvertor)new RowConvertor<Integer, List<Long>>(){

            public boolean isParallel() {
                return true;
            }

            public List<Long> convert(int rowIndex, Integer obj) {
                ArrayList<Long> subList = new ArrayList<Long>();
                subList.add(Thread.currentThread().getId());
                return ListConvertUtil.transform(subList, (RowConvertor)RowConvertorBuilder.parallel(internalObj -> {
                    Long cid = Thread.currentThread().getId();
                    if (policy == ParallelRecursivePolicy.CURRENT_THREAD) {
                        Assert.assertEquals((Object)cid, (Object)internalObj);
                    } else {
                        Assert.assertNotEquals((Object)cid, (Object)internalObj);
                    }
                    return cid;
                }));
            }
        });
    }

    public void testNumberLimitOfParallel() {
        Configuration.getConfiguration().setNumberLimitOfParallelListConverting(3);
        List<Integer> list = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9);
        long start = System.currentTimeMillis();
        List rList = ListConvertUtil.transform(list, (RowConvertor)RowConvertorBuilder.parallel(i -> {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return i;
        }));
        long end = System.currentTimeMillis();
        long timeUsed = end - start;
        if (timeUsed < 200L) {
            throw new AssertionError((Object)("Time used is less than 200 milliseconds with only " + timeUsed + " milliseconds."));
        }
        if (timeUsed > 350L) {
            throw new AssertionError((Object)("Time used is over than 350 milliseconds and it takes " + timeUsed + " milliseconds."));
        }
        Assert.assertEquals((Collection)rList, list);
    }
}

