/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.unit;

import com.astamuse.asta4d.util.MultiSearchPathResourceLoader;
import junit.framework.Assert;
import org.testng.annotations.Test;

public class MultiSearchPathResourceLoaderTest {
    @Test
    public void searchForOneName() {
        StringResourceLoaderForTest loader = new StringResourceLoaderForTest(new String[]{"foo", "bar", "baz"});
        String resource = (String)loader.searchResource("/", new String[]{"bar"});
        Assert.assertEquals((String)"bar", (String)resource);
    }

    @Test
    public void searchForMultiName() {
        StringResourceLoaderForTest loader = new StringResourceLoaderForTest(new String[]{"foo", "bar", "baz"});
        String resource = (String)loader.searchResource("/", new String[]{"qux", "baz"});
        Assert.assertEquals((String)"baz", (String)resource);
    }

    @Test
    public void searchForMultiName_NotFound() {
        StringResourceLoaderForTest loader = new StringResourceLoaderForTest(new String[]{"foo", "bar", "baz"});
        String resource = (String)loader.searchResource("/", new String[]{"qux", "quux"});
        Assert.assertNull((Object)resource);
    }

    @Test
    public void searchForMultiPath() {
        StringResourceLoaderForTest loader = new StringResourceLoaderForTest(new String[]{"foo", "bar", "baz", "path1/bar", "path2/qux"});
        loader.setSearchPathList(new String[]{"path1", "path2"});
        String resource = (String)loader.searchResource("/", new String[]{"qux"});
        Assert.assertEquals((String)"path2/qux", (String)resource);
    }

    @Test
    public void searchForMultiPath_FindMultiResource() {
        StringResourceLoaderForTest loader = new StringResourceLoaderForTest(new String[]{"foo", "bar", "baz", "path1/bar", "path2/qux"});
        loader.setSearchPathList(new String[]{"path1", "path2"});
        String resource = (String)loader.searchResource("/", new String[]{"bar"});
        Assert.assertEquals((String)"bar", (String)resource);
    }

    @Test
    public void searchForMultiPath_NotFound() {
        StringResourceLoaderForTest loader = new StringResourceLoaderForTest(new String[]{"foo", "bar", "baz", "path1/bar", "path2/qux"});
        loader.setSearchPathList(new String[]{"path1", "path2"});
        String resource = (String)loader.searchResource("/", new String[]{"quux", "foobar"});
        Assert.assertNull((Object)resource);
    }

    private static class StringResourceLoaderForTest
    extends MultiSearchPathResourceLoader<String> {
        private final String[] resources;

        public StringResourceLoaderForTest(String[] resources) {
            this.resources = resources;
        }

        protected String loadResource(String name) {
            for (String resource : this.resources) {
                if (!resource.equals(name)) continue;
                return resource;
            }
            return null;
        }
    }
}

