/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.unit;

import com.astamuse.asta4d.interceptor.base.ExceptionHandler;
import com.astamuse.asta4d.interceptor.base.Executor;
import com.astamuse.asta4d.interceptor.base.GenericInterceptor;
import com.astamuse.asta4d.interceptor.base.InterceptorUtil;
import java.util.ArrayList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InterceptorUtilTest {
    @Test
    public void succeedAllProcess() throws Exception {
        TestHolder holder = new TestHolder();
        ArrayList<TestIntercepter> interceptorList = new ArrayList<TestIntercepter>();
        interceptorList.add(new TestIntercepter("Intercepter1"));
        interceptorList.add(new TestIntercepter("Intercepter2"));
        interceptorList.add(new TestIntercepter("Intercepter3"));
        TestExecutor executor = new TestExecutor();
        InterceptorUtil.executeWithInterceptors((Object)holder, interceptorList, (Executor)executor);
        Assert.assertEquals((Object[])holder.getExecutedBeforeProcessNames(), (Object[])new String[]{"Intercepter1", "Intercepter2", "Intercepter3"});
        Assert.assertEquals((Object[])holder.getExecutedAfterProcessNames(), (Object[])new String[]{"Intercepter3", "Intercepter2", "Intercepter1"});
    }

    @Test
    public void breakBeforeProcess() throws Exception {
        TestHolder holder = new TestHolder();
        ArrayList<TestIntercepter> interceptorList = new ArrayList<TestIntercepter>();
        interceptorList.add(new TestIntercepter("Intercepter1"));
        interceptorList.add(new TestIntercepter("Intercepter2", false, false));
        interceptorList.add(new TestIntercepter("Intercepter3"));
        TestExecutor executor = new TestExecutor();
        InterceptorUtil.executeWithInterceptors((Object)holder, interceptorList, (Executor)executor);
        Assert.assertEquals((Object[])holder.getExecutedBeforeProcessNames(), (Object[])new String[]{"Intercepter1", "Intercepter2"});
        Assert.assertEquals((Object[])holder.getExecutedAfterProcessNames(), (Object[])new String[]{"Intercepter1"});
    }

    @Test
    public void failureMainProcess() throws Exception {
        TestHolder holder = new TestHolder();
        ArrayList<TestIntercepter> interceptorList = new ArrayList<TestIntercepter>();
        interceptorList.add(new TestIntercepter("Intercepter1"));
        interceptorList.add(new TestIntercepter("Intercepter2"));
        interceptorList.add(new TestIntercepter("Intercepter3"));
        TestExecutor executor = new TestExecutor(true);
        try {
            InterceptorUtil.executeWithInterceptors((Object)holder, interceptorList, (Executor)executor);
            Assert.fail((String)"No exceptions occurred.");
        }
        catch (TestException e) {
            Assert.assertEquals((Object[])holder.getExecutedBeforeProcessNames(), (Object[])new String[]{"Intercepter1", "Intercepter2", "Intercepter3"});
            Assert.assertEquals((Object[])holder.getExecutedAfterProcessNames(), (Object[])new String[]{"Intercepter3", "Intercepter2", "Intercepter1"});
        }
    }

    @Test
    public void failureBeforeProcess() throws Exception {
        TestHolder holder = new TestHolder();
        ArrayList<TestIntercepter> interceptorList = new ArrayList<TestIntercepter>();
        interceptorList.add(new TestIntercepter("Intercepter1"));
        interceptorList.add(new TestIntercepter("Intercepter2", true, true));
        interceptorList.add(new TestIntercepter("Intercepter3"));
        TestExecutor executor = new TestExecutor();
        try {
            InterceptorUtil.executeWithInterceptors((Object)holder, interceptorList, (Executor)executor);
            Assert.fail((String)"No exceptions occurred.");
        }
        catch (TestException e) {
            Assert.assertEquals((Object[])holder.getExecutedBeforeProcessNames(), (Object[])new String[]{"Intercepter1", "Intercepter2"});
            Assert.assertEquals((Object[])holder.getExecutedAfterProcessNames(), (Object[])new String[]{"Intercepter1"});
        }
    }

    public static class TestException
    extends Exception {
    }

    public static class TestIntercepter
    implements GenericInterceptor<TestHolder> {
        private final String name;
        private final boolean beforeResult;
        private final boolean failureBefore;

        public TestIntercepter(String name) {
            this(name, true, false);
        }

        public TestIntercepter(String name, boolean beforeResult, boolean failBefore) {
            this.name = name;
            this.beforeResult = beforeResult;
            this.failureBefore = failBefore;
        }

        public boolean beforeProcess(TestHolder executionHolder) throws Exception {
            executionHolder.addBeforeProcessName(this.name);
            if (this.failureBefore) {
                throw new TestException();
            }
            return this.beforeResult;
        }

        public void afterProcess(TestHolder executionHolder, ExceptionHandler exceptionHandler) {
            executionHolder.addAfterProcessName(this.name);
        }
    }

    public static class TestExecutor
    implements Executor<TestHolder> {
        private final boolean failure;

        public TestExecutor() {
            this(false);
        }

        public TestExecutor(boolean failure) {
            this.failure = failure;
        }

        public void execute(TestHolder executionHolder) throws Exception {
            if (this.failure) {
                throw new TestException();
            }
        }
    }

    private static class TestHolder {
        private final List<String> executedBeforeProcessNames = new ArrayList<String>();
        private final List<String> executedAfterProcessNames = new ArrayList<String>();

        private TestHolder() {
        }

        public void addBeforeProcessName(String name) {
            this.executedBeforeProcessNames.add(name);
        }

        public void addAfterProcessName(String name) {
            this.executedAfterProcessNames.add(name);
        }

        public String[] getExecutedBeforeProcessNames() {
            return this.executedBeforeProcessNames.toArray(new String[this.executedBeforeProcessNames.size()]);
        }

        public String[] getExecutedAfterProcessNames() {
            return this.executedAfterProcessNames.toArray(new String[this.executedAfterProcessNames.size()]);
        }
    }
}

