/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.unit;

import com.astamuse.asta4d.Context;
import com.astamuse.asta4d.data.ContextDataHolder;
import com.astamuse.asta4d.data.DataOperationException;
import com.astamuse.asta4d.data.InjectTrace;
import com.astamuse.asta4d.data.InjectUtil;
import com.astamuse.asta4d.data.TypeUnMacthPolicy;
import com.astamuse.asta4d.data.annotation.ContextData;
import com.astamuse.asta4d.data.annotation.ContextDataSet;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InjectUtilForTypeUnMatchTest
extends BaseTest {
    @Test(expectedExceptions={DataOperationException.class}, expectedExceptionsMessageRegExp=".*cannot be coverted from.*")
    public void exceptionWhenInjectableOnMethodSetParam() throws Exception {
        Context ctx = Context.getCurrentThreadContext();
        ctx.setData("f1", (Object)"xx77");
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForTypeUnMatchTest.getMethod("requestHolderForException", TestSetForException.class));
    }

    @Test(expectedExceptions={DataOperationException.class}, expectedExceptionsMessageRegExp=".*cannot be coverted from.*")
    public void exceptionWhenInjectableOnMethodParam() throws Exception {
        Context ctx = Context.getCurrentThreadContext();
        ctx.setData("holder", (Object)"xx77");
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForTypeUnMatchTest.getMethod("requestHolderForException", Integer.TYPE));
    }

    @Test(expectedExceptions={DataOperationException.class}, expectedExceptionsMessageRegExp=".*cannot be coverted from.*")
    public void exceptionWhenInjectableOnMethodParam2() throws Exception {
        Context ctx = Context.getCurrentThreadContext();
        ctx.setData("holder", (Object)"xx77");
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForTypeUnMatchTest.getMethod("requestHolderForException2", Integer.TYPE));
    }

    @Test(expectedExceptions={DataOperationException.class}, expectedExceptionsMessageRegExp=".*cannot be coverted from.*")
    public void exceptionWhenInjectableOnMethodParam3() throws Exception {
        Context ctx = Context.getCurrentThreadContext();
        ctx.setData("holder", (Object)"xx77");
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForTypeUnMatchTest.getMethod("requestHolderForException3", Integer.TYPE));
    }

    @Test(expectedExceptions={DataOperationException.class}, expectedExceptionsMessageRegExp=".*cannot be coverted from.*")
    public void exceptionWhenInjectArrayDataOnMethodSetParam() throws Exception {
        Context ctx = Context.getCurrentThreadContext();
        ctx.setData("f1", (Object)new String[]{"xx77"});
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForTypeUnMatchTest.getMethod("requestHolderForException", TestSetForException.class));
    }

    @Test(enabled=false)
    public void requestHolderForException(TestSetForException holder) {
    }

    @Test(enabled=false)
    public void requestHolderForException(@ContextData(typeUnMatch=TypeUnMacthPolicy.EXCEPTION) int holder) {
    }

    @Test(enabled=false)
    public void requestHolderForException2(@ContextData int holder) {
    }

    @Test(enabled=false)
    public void requestHolderForException3(int holder) {
    }

    @Test
    public void defaultValueWhenInjectableOnMethodSetParam() throws Exception {
        Context ctx = Context.getCurrentThreadContext();
        ctx.setData("f1", (Object)"xx77");
        ctx.setData("f2", (Object)"xx66");
        ctx.setData("f3", (Object)"xx55");
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForTypeUnMatchTest.getMethod("requestHolderForDefaultValue", TestSetForDefaultValue.class));
        TestSetForDefaultValue set = (TestSetForDefaultValue)params[0];
        Assert.assertEquals((long)set.getF1(), (long)0L);
        Assert.assertEquals((long)set.getF2(), (long)0L);
        Assert.assertNull((Object)set.getF3());
        Field field1 = TestSetForDefaultValue.class.getDeclaredField("f1");
        ContextDataHolder traceHolder = InjectTrace.getInstanceInjectionTraceInfo((Object)set, (Field)field1);
        Assert.assertNull((Object)traceHolder);
        Field field2 = TestSetForDefaultValue.class.getDeclaredField("f2");
        traceHolder = InjectTrace.getInstanceInjectionTraceInfo((Object)set, (Field)field2);
        Assert.assertEquals((Object)traceHolder.getFoundOriginalData(), (Object)"xx66");
        Field field3 = TestSetForDefaultValue.class.getDeclaredField("f3");
        traceHolder = InjectTrace.getInstanceInjectionTraceInfo((Object)set, (Field)field3);
        Assert.assertEquals((Object)traceHolder.getFoundOriginalData(), (Object)"xx55");
    }

    @Test
    public void defaultValueWhenInjectableOnMethodParam() throws Exception {
        Context ctx = Context.getCurrentThreadContext();
        ctx.setData("f1", (Object)"xx77");
        ctx.setData("f2", (Object)"xx66");
        Method m = InjectUtilForTypeUnMatchTest.getMethod("requestHolderForDefaultValue", Integer.TYPE, Integer.TYPE);
        Object[] params = InjectUtil.getMethodInjectParams((Method)m);
        Assert.assertEquals((Object)params[0], (Object)0);
        Assert.assertEquals((Object)params[1], (Object)0);
        ContextDataHolder traceHolder = InjectTrace.getMethodInjectionTraceInfo((Method)m, (int)0);
        Assert.assertNull((Object)traceHolder);
        traceHolder = InjectTrace.getMethodInjectionTraceInfo((Method)m, (int)1);
        Assert.assertEquals((Object)traceHolder.getFoundOriginalData(), (Object)"xx66");
    }

    @Test(enabled=false)
    public void requestHolderForDefaultValue(TestSetForDefaultValue holder) {
    }

    @Test(enabled=false)
    public void requestHolderForDefaultValue(@ContextData(typeUnMatch=TypeUnMacthPolicy.DEFAULT_VALUE) int f1, @ContextData(typeUnMatch=TypeUnMacthPolicy.DEFAULT_VALUE_AND_TRACE) int f2) {
    }

    private static Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return InjectUtilForTypeUnMatchTest.class.getMethod(name, parameterTypes);
    }

    @ContextDataSet
    public static class TestSetForDefaultValue {
        @ContextData(typeUnMatch=TypeUnMacthPolicy.DEFAULT_VALUE)
        private long f1 = -1L;
        @ContextData(typeUnMatch=TypeUnMacthPolicy.DEFAULT_VALUE_AND_TRACE)
        private long f2 = -1L;
        @ContextData(typeUnMatch=TypeUnMacthPolicy.DEFAULT_VALUE_AND_TRACE)
        private Date f3 = new Date(0L);

        public long getF1() {
            return this.f1;
        }

        public long getF2() {
            return this.f2;
        }

        public Date getF3() {
            return this.f3;
        }
    }

    @ContextDataSet
    public static class TestSetForException {
        @ContextData(typeUnMatch=TypeUnMacthPolicy.EXCEPTION)
        private long f1 = -1L;

        public long getF1() {
            return this.f1;
        }
    }
}

