/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.unit;

import com.astamuse.asta4d.Context;
import com.astamuse.asta4d.data.InjectUtil;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InjectUtilForMethodTest
extends BaseTest {
    @Test
    public void stringNotFound() throws Exception {
        InjectUtilForMethodTest.setData(null);
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireString", String.class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], null);
    }

    @Test
    public void string2string() throws Exception {
        InjectUtilForMethodTest.setData("value");
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireString", String.class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], (Object)"value");
    }

    @Test
    public void string2StringArray() throws Exception {
        InjectUtilForMethodTest.setData(new String[]{"aa", "bb"});
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireString", String.class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], (Object)"aa");
    }

    @Test
    public void stringArray2String() throws Exception {
        InjectUtilForMethodTest.setData("value");
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireString", String[].class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], (Object)new String[]{"value"});
    }

    @Test
    public void stringArray2StringArray() throws Exception {
        InjectUtilForMethodTest.setData(new String[]{"aa", "bb"});
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireString", String[].class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], (Object)new String[]{"aa", "bb"});
    }

    @Test
    public void boolean2boolean() throws Exception {
        InjectUtilForMethodTest.setData(true);
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireBoolean", Boolean.TYPE));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertTrue((boolean)((Boolean)params[0]));
    }

    @Test
    public void boolean2booleanArray() throws Exception {
        InjectUtilForMethodTest.setData(true);
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireBoolean", boolean[].class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], (Object)new boolean[]{true});
    }

    @Test
    public void booleanArray2boolean() throws Exception {
        InjectUtilForMethodTest.setData(new boolean[]{true, false});
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireBoolean", Boolean.TYPE));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertTrue((boolean)((Boolean)params[0]));
    }

    @Test
    public void booleanArray2booleanArray() throws Exception {
        InjectUtilForMethodTest.setData(new boolean[]{true, false});
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireBoolean", boolean[].class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], (Object)new boolean[]{true, false});
    }

    @Test
    public void string2boolean() throws Exception {
        InjectUtilForMethodTest.setData("true");
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireBoolean", Boolean.TYPE));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertTrue((boolean)((Boolean)params[0]));
    }

    @Test
    public void string2booleanArray() throws Exception {
        InjectUtilForMethodTest.setData("true");
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireBoolean", Boolean.TYPE));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertTrue((boolean)((Boolean)params[0]));
    }

    @Test
    public void stringArray2boolean() throws Exception {
        InjectUtilForMethodTest.setData(new String[]{"true", "false"});
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireBoolean", Boolean.TYPE));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertTrue((boolean)((Boolean)params[0]));
    }

    @Test
    public void stringArray2booleanArray() throws Exception {
        InjectUtilForMethodTest.setData(new String[]{"true", "false"});
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireBoolean", boolean[].class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], (Object)new boolean[]{true, false});
    }

    @Test
    public void int2int() throws Exception {
        InjectUtilForMethodTest.setData(10);
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireInt", Integer.TYPE));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((int)((Integer)params[0]), (int)10);
    }

    @Test
    public void int2intArray() throws Exception {
        InjectUtilForMethodTest.setData(15);
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireInt", int[].class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], (Object)new int[]{15});
    }

    @Test
    public void intArray2int() throws Exception {
        InjectUtilForMethodTest.setData(new int[]{10, 20});
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireInt", Integer.TYPE));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((int)((Integer)params[0]), (int)10);
    }

    @Test
    public void intArray2intArray() throws Exception {
        InjectUtilForMethodTest.setData(new int[]{10, 20});
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireInt", int[].class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], (Object)new int[]{10, 20});
    }

    @Test
    public void string2int() throws Exception {
        InjectUtilForMethodTest.setData("15");
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireInt", Integer.TYPE));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((int)((Integer)params[0]), (int)15);
    }

    @Test
    public void string2intArray() throws Exception {
        InjectUtilForMethodTest.setData("15");
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireInt", int[].class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], (Object)new int[]{15});
    }

    @Test
    public void stringArray2int() throws Exception {
        InjectUtilForMethodTest.setData(new String[]{"10", "20"});
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireInt", Integer.TYPE));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((int)((Integer)params[0]), (int)10);
    }

    @Test
    public void stringArray2intArray() throws Exception {
        InjectUtilForMethodTest.setData(new String[]{"10", "20"});
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireInt", int[].class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], (Object)new int[]{10, 20});
    }

    @Test
    public void long2long() throws Exception {
        InjectUtilForMethodTest.setData(15L);
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireLong", Long.TYPE));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((long)((Long)params[0]), (long)15L);
    }

    @Test
    public void long2longArray() throws Exception {
        InjectUtilForMethodTest.setData(15L);
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireLong", long[].class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], (Object)new long[]{15L});
    }

    @Test
    public void longArray2long() throws Exception {
        InjectUtilForMethodTest.setData(new long[]{10L, 20L});
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireLong", Long.TYPE));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((long)((Long)params[0]), (long)10L);
    }

    @Test
    public void longArray2longArray() throws Exception {
        InjectUtilForMethodTest.setData(new long[]{10L, 20L});
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireLong", long[].class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], (Object)new long[]{10L, 20L});
    }

    @Test
    public void string2long() throws Exception {
        InjectUtilForMethodTest.setData("15");
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireLong", Long.TYPE));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((long)((Long)params[0]), (long)15L);
    }

    @Test
    public void string2longArray() throws Exception {
        InjectUtilForMethodTest.setData("15");
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireLong", long[].class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], (Object)new long[]{15L});
    }

    @Test
    public void stringArray2long() throws Exception {
        InjectUtilForMethodTest.setData(new String[]{"10", "20"});
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireLong", Long.TYPE));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((long)((Long)params[0]), (long)10L);
    }

    @Test
    public void stringArray2longArray() throws Exception {
        InjectUtilForMethodTest.setData(new String[]{"10", "20"});
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("requireLong", long[].class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], (Object)new long[]{10L, 20L});
    }

    @Test
    public void lambdaInside() throws Exception {
        InjectUtilForMethodTest.setData(null);
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForMethodTest.getMethod("lambdaInside", String.class));
        Assert.assertEquals((int)params.length, (int)1);
        Assert.assertEquals((Object)params[0], null);
    }

    @Test(enabled=false)
    public void requireString(String param) {
    }

    @Test(enabled=false)
    public void requireString(String[] param) {
    }

    @Test(enabled=false)
    public void requireBoolean(boolean param) {
    }

    @Test(enabled=false)
    public void requireBoolean(boolean[] param) {
    }

    @Test(enabled=false)
    public void requireInt(int param) {
    }

    @Test(enabled=false)
    public void requireInt(int[] param) {
    }

    @Test(enabled=false)
    public void requireLong(long param) {
    }

    @Test(enabled=false)
    public void requireLong(long[] param) {
    }

    @Test(enabled=false)
    public void lambdaInside(String param) {
        List<String> names = Arrays.asList("hoge hoge", "foo bar", "naoki", "kishida");
        names.stream().forEach(s -> System.out.println((String)s));
    }

    private static void setData(Object data) {
        Context context = Context.getCurrentThreadContext();
        context.setData("param", data);
    }

    private static Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return InjectUtilForMethodTest.class.getMethod(name, parameterTypes);
    }
}

