/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.unit;

import com.astamuse.asta4d.Context;
import com.astamuse.asta4d.data.ContextDataHolder;
import com.astamuse.asta4d.data.InjectUtil;
import com.astamuse.asta4d.data.annotation.ContextData;
import com.astamuse.asta4d.data.annotation.ContextDataSet;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import java.lang.reflect.Method;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InjectUtilForInstanceTest
extends BaseTest {
    @Test
    public void contextSetAndInjectableOnMethod() throws Exception {
        Context ctx = Context.getCurrentThreadContext();
        ctx.setData("f1", (Object)"6678");
        ctx.setData("f2", (Object)"12345");
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForInstanceTest.getMethod("requireHolder", TestSet.class));
        TestSet set = (TestSet)params[0];
        Assert.assertEquals((long)set.getF1(), (long)6678L);
        Assert.assertEquals((long)((Long)set.f2.getValue()), (long)12345L);
    }

    @Test(enabled=false)
    public void requireHolder(TestSet holder) {
    }

    @Test
    public void contextSetAndInjectableOnInstance() throws Exception {
        Context ctx = Context.getCurrentThreadContext();
        ctx.setData("f1", (Object)"6678");
        ctx.setData("f2", (Object)"12345");
        ctx.setData("f3", (Object)"QQQ");
        TestCls tc = new TestCls();
        InjectUtil.injectToInstance((Object)tc);
        Assert.assertEquals((long)tc.myset.getF1(), (long)6678L);
        Assert.assertEquals((long)((Long)((TestCls)tc).myset.f2.getValue()), (long)12345L);
        Assert.assertEquals((String)tc.myset.getF3(), (String)"QQQ");
        Assert.assertEquals((long)tc.mySingletonSet.getF1(), (long)6678L);
        Assert.assertEquals((long)((Long)((TestCls)tc).mySingletonSet.f2.getValue()), (long)12345L);
        TestCls tc2 = new TestCls();
        InjectUtil.injectToInstance((Object)tc2);
        Assert.assertEquals((tc.myset == tc2.myset ? 1 : 0) != 0, (boolean)false);
        Assert.assertEquals((tc.mySingletonSet == tc2.mySingletonSet ? 1 : 0) != 0, (boolean)true);
    }

    @Test
    public void retriveContextSetInScopeFirst() throws Exception {
        Context ctx = Context.getCurrentThreadContext();
        ctx.setData("f1", (Object)"6678");
        ctx.setData("f2", (Object)"12345");
        TestCls tc = new TestCls();
        InjectUtil.injectToInstance((Object)tc);
        TestSet set = tc.myset;
        ctx.setData("myset", (Object)set);
        tc = new TestCls();
        InjectUtil.injectToInstance((Object)tc);
        Assert.assertEquals((tc.myset == set ? 1 : 0) != 0, (boolean)true);
    }

    private static Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return InjectUtilForInstanceTest.class.getMethod(name, parameterTypes);
    }

    public static class TestCls {
        @ContextData
        private TestSet myset;
        @ContextData
        private TestSingletonSet mySingletonSet;
    }

    @ContextDataSet(singletonInContext=true)
    public static class TestSingletonSet {
        @ContextData
        private long f1;
        @ContextData
        public ContextDataHolder<Long> f2 = new ContextDataHolder(Long.class);

        public long getF1() {
            return this.f1;
        }
    }

    @ContextDataSet(singletonInContext=false)
    public static class TestSet {
        @ContextData
        private long f1;
        @ContextData
        public ContextDataHolder<Long> f2 = new ContextDataHolder(Long.class);
        private String f3;

        public long getF1() {
            return this.f1;
        }

        @ContextData
        public String getF3() {
            return this.f3;
        }

        public void setF3(String f3) {
            this.f3 = f3;
        }
    }
}

