/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.unit;

import com.astamuse.asta4d.Context;
import com.astamuse.asta4d.data.ContextDataHolder;
import com.astamuse.asta4d.data.ContextDataSetFactory;
import com.astamuse.asta4d.data.DefaultContextDataSetFactory;
import com.astamuse.asta4d.data.InjectUtil;
import com.astamuse.asta4d.data.TypeUnMacthPolicy;
import com.astamuse.asta4d.data.annotation.ContextData;
import com.astamuse.asta4d.data.annotation.ContextDataSet;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import com.astamuse.asta4d.util.annotation.AnnotationConvertor;
import com.astamuse.asta4d.util.annotation.ConvertableAnnotation;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InjectUtilForConvertableAnnotationTest
extends BaseTest {
    private static final String MyDataScope = "MyDataScope";

    @Test
    public void contextSetAndInjectableOnMethod() throws Exception {
        Context ctx = Context.getCurrentThreadContext();
        ctx.setData(MyDataScope, "f1", (Object)"6678");
        ctx.setData("f2", (Object)"12345");
        Object[] params = InjectUtil.getMethodInjectParams((Method)InjectUtilForConvertableAnnotationTest.getMethod("requireHolder", TestSet.class));
        TestSet set = (TestSet)params[0];
        Assert.assertEquals((long)set.getF1(), (long)6678L);
        Assert.assertEquals((long)((Long)set.f2.getValue()), (long)12345L);
    }

    @Test
    public void contextSetAndInjectableOnInstance() throws Exception {
        Context ctx = Context.getCurrentThreadContext();
        ctx.setData(MyDataScope, "f1", (Object)"6678");
        ctx.setData("f2", (Object)"12345");
        TestCls tc = new TestCls();
        InjectUtil.injectToInstance((Object)tc);
        TestSet set = tc.myset;
        Assert.assertEquals((long)set.getF1(), (long)6678L);
        Assert.assertEquals((long)((Long)set.f2.getValue()), (long)12345L);
    }

    @Test(enabled=false)
    public void requireHolder(TestSet holder) {
    }

    private static Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        return InjectUtilForConvertableAnnotationTest.class.getMethod(name, parameterTypes);
    }

    public static class TestCls {
        @ContextData
        private TestSet myset;
    }

    @MySet
    public static class TestSet {
        @MyData
        private long f1;
        @ContextData
        public ContextDataHolder<Long> f2 = new ContextDataHolder(Long.class);

        public long getF1() {
            return this.f1;
        }
    }

    public static class MyDataConvertor
    implements AnnotationConvertor<MyData, ContextData> {
        public ContextData convert(final MyData originalAnnotation) {
            return new ContextData(){

                public Class<? extends Annotation> annotationType() {
                    return ContextData.class;
                }

                public String name() {
                    return originalAnnotation.name();
                }

                public String scope() {
                    return InjectUtilForConvertableAnnotationTest.MyDataScope;
                }

                public TypeUnMacthPolicy typeUnMatch() {
                    return TypeUnMacthPolicy.DEFAULT_VALUE;
                }
            };
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
    @ConvertableAnnotation(value=MyDataConvertor.class)
    public static @interface MyData {
        public String name() default "";
    }

    public static class MySetConvertor
    implements AnnotationConvertor<MySet, ContextDataSet> {
        public ContextDataSet convert(MySet originalAnnotation) {
            return new ContextDataSet(){

                public Class<? extends Annotation> annotationType() {
                    return ContextDataSet.class;
                }

                public Class<? extends ContextDataSetFactory> factory() {
                    return DefaultContextDataSetFactory.class;
                }

                public boolean singletonInContext() {
                    return false;
                }
            };
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @ConvertableAnnotation(value=MySetConvertor.class)
    public static @interface MySet {
    }
}

