/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.unit;

import com.astamuse.asta4d.test.render.infra.BaseTest;
import com.astamuse.asta4d.util.annotation.AnnotationConvertor;
import com.astamuse.asta4d.util.annotation.ConvertableAnnotation;
import com.astamuse.asta4d.util.annotation.ConvertableAnnotationRetriever;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConvertableAnnotationTest
extends BaseTest {
    @Test
    public void testOneLayerConvert() {
        FinalAnnotationA fa = (FinalAnnotationA)ConvertableAnnotationRetriever.retrieveAnnotation(FinalAnnotationA.class, (Annotation[])HA.class.getAnnotations());
        Assert.assertEquals((int)fa.value(), (int)45);
    }

    public void testTwoLayerConvert() {
        FinalAnnotationB fb = (FinalAnnotationB)ConvertableAnnotationRetriever.retrieveAnnotation(FinalAnnotationB.class, (Annotation[])HB.class.getAnnotations());
        Assert.assertEquals((String)fb.value(), (String)"v-90");
    }

    public void testNotFound() {
        FinalAnnotationC fc = (FinalAnnotationC)ConvertableAnnotationRetriever.retrieveAnnotation(FinalAnnotationC.class, (Annotation[])HB.class.getAnnotations());
        Assert.assertNull((Object)fc);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FinalAnnotationC {
    }

    @AnnotationBBB(value="90")
    public static class HB {
    }

    public static class ConvertBB
    implements AnnotationConvertor<AnnotationBB, FinalAnnotationB> {
        public FinalAnnotationB convert(final AnnotationBB originalAnnotation) {
            return new FinalAnnotationB(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return FinalAnnotationB.class;
                }

                @Override
                public String value() {
                    return "v-" + originalAnnotation.value();
                }
            };
        }
    }

    public static class ConvertBBB
    implements AnnotationConvertor<AnnotationBBB, AnnotationBB> {
        public AnnotationBB convert(final AnnotationBBB originalAnnotation) {
            return new AnnotationBB(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return AnnotationBB.class;
                }

                @Override
                public int value() {
                    return Integer.parseInt(originalAnnotation.value());
                }
            };
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @ConvertableAnnotation(value=ConvertBBB.class)
    public static @interface AnnotationBBB {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @ConvertableAnnotation(value=ConvertBB.class)
    public static @interface AnnotationBB {
        public int value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FinalAnnotationB {
        public String value();
    }

    @AnnotationAA(value="45")
    public static class HA {
    }

    public static class ConvertAA
    implements AnnotationConvertor<AnnotationAA, FinalAnnotationA> {
        public FinalAnnotationA convert(final AnnotationAA originalAnnotation) {
            return new FinalAnnotationA(){

                @Override
                public Class<? extends Annotation> annotationType() {
                    return FinalAnnotationA.class;
                }

                @Override
                public int value() {
                    return Integer.parseInt(originalAnnotation.value());
                }
            };
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @ConvertableAnnotation(value=ConvertAA.class)
    public static @interface AnnotationAA {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface FinalAnnotationA {
        public int value();
    }
}

