/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.render.infra;

import com.astamuse.asta4d.Page;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.testng.Assert;

public class SimpleCase {
    public SimpleCase(String templateFileName) throws Throwable {
        this(templateFileName, templateFileName);
    }

    public SimpleCase(String templateFileName, String confirmFileName) throws Throwable {
        String ostr = null;
        String cstr = null;
        try {
            Page originPage = Page.buildFromPath((String)(this.retrieveTempateFielParentPath() + templateFileName));
            ostr = this.revert2comparableString(originPage);
            cstr = this.revert2comparableString(this.retrieveConfirmFielParentPath() + confirmFileName);
            Assert.assertEquals((String)ostr, (String)cstr);
        }
        catch (Throwable t) {
            this.output(templateFileName + ":rendering result", ostr);
            this.output(confirmFileName + ":expected result", cstr);
            throw t;
        }
    }

    protected String retrieveTempateFielParentPath() {
        return "/com/astamuse/asta4d/test/render/templates/";
    }

    protected String retrieveConfirmFielParentPath() {
        return "/com/astamuse/asta4d/test/render/confirms/";
    }

    private String revert2comparableString(Page page) {
        return page.output();
    }

    private String revert2comparableString(String path) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(SimpleCase.class.getResourceAsStream(path), "UTF-8"));){
            int line;
            StringBuilder sb = new StringBuilder();
            char[] b = new char[1024];
            while (0 <= (line = reader.read(b))) {
                sb.append(b, 0, line);
            }
            String string = sb.toString();
            return string;
        }
    }

    private void output(String title, String page) {
        System.out.println(String.format("===============%s===================", title));
        if (page == null) {
            System.out.println("##null##");
        } else {
            System.out.println(page);
        }
        System.out.println("===============================================================");
    }
}

