/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.render;

import com.astamuse.asta4d.Context;
import com.astamuse.asta4d.data.annotation.ContextData;
import com.astamuse.asta4d.render.Renderer;
import com.astamuse.asta4d.snippet.InitializableSnippet;
import com.astamuse.asta4d.snippet.SnippetInvokeException;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import com.astamuse.asta4d.test.render.infra.SimpleCase;
import org.testng.annotations.Test;

public class SimpleSnippetRenderingTest
extends BaseTest {
    public void testTagEmbed() throws Throwable {
        new SimpleCase("SimpleSnippet_TagEmbed.html");
    }

    @Test(enabled=false)
    public void testStaticEmbed() throws Throwable {
        new SimpleCase("SimpleSnippet_StaticEmbed.html");
    }

    public void testSnippetTag() throws Throwable {
        new SimpleCase("SimpleSnippet_SnippetTag.html");
    }

    public void testBasePackageSnippetSearch() throws Throwable {
        new SimpleCase("SimpleSnippet_BasePackage.html");
    }

    public void testSnippetInit() throws Throwable {
        Context.getCurrentThreadContext().setData("value", (Object)"fire");
        new SimpleCase("SimpleSnippet_SnippetInit.html");
    }

    public void testAttrConflict() throws Throwable {
        new SimpleCase("SimpleSnippet_AttrConflict.html");
    }

    public static class AttrConflict {
        public Renderer outer() {
            return Renderer.create((String)"afd|snippet", (String)"status", (Integer)5);
        }

        public Renderer inner(int status) {
            return Renderer.create((String)"#x-status", (Integer)status);
        }
    }

    public static class InitSnippet
    implements InitializableSnippet {
        @ContextData
        private String value;
        private long id;
        private String resolvedValue;
        private int count = 0;

        public void init() throws SnippetInvokeException {
            this.resolvedValue = this.value + "-resolved";
            ++this.count;
        }

        @ContextData
        private void setId(long id) {
            this.id = id;
        }

        public Renderer render_1() {
            return Renderer.create((String)".value", (String)this.resolvedValue).add(".count", Integer.valueOf(this.count));
        }

        public Renderer render_2() {
            return Renderer.create((String)".value", (String)this.resolvedValue).add(".count", Integer.valueOf(this.count));
        }
    }

    public static class SnippetTag {
        public Renderer render() {
            return Renderer.create((String)"span", (String)"wow");
        }
    }

    public static class TagEmbed {
        public Renderer render(String ctype) {
            return Renderer.create((String)"span", (String)ctype);
        }
    }

    public static class StaticEmbed {
        public Renderer render(String ctype) {
            return Renderer.create((String)"#hellodiv", (String)"statically loaded before snippet being executed");
        }
    }
}

