/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.render;

import com.astamuse.asta4d.render.ChildReplacer;
import com.astamuse.asta4d.render.ElementSetter;
import com.astamuse.asta4d.render.GoThroughRenderer;
import com.astamuse.asta4d.render.Renderable;
import com.astamuse.asta4d.render.Renderer;
import com.astamuse.asta4d.render.SpecialRenderer;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import com.astamuse.asta4d.test.render.infra.SimpleCase;
import com.astamuse.asta4d.util.ElementUtil;
import com.astamuse.asta4d.util.collection.RowConvertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jsoup.nodes.Element;

public class RenderingTest
extends BaseTest {
    public void testElementRendering() throws Throwable {
        new SimpleCase("Rendering_elementRendering.html");
    }

    public void testTextRendering() throws Throwable {
        new SimpleCase("Rendering_textRendering.html");
    }

    public void testPseudoRootRendering() throws Throwable {
        new SimpleCase("Rendering_pseudoRootRendering.html");
    }

    public void testNormalAttrSetting() throws Throwable {
        new SimpleCase("Rendering_normalAttrSetting.html");
    }

    public void testClassAttrSetting() throws Throwable {
        new SimpleCase("Rendering_classAttrSetting.html");
    }

    public void testRemoveClassInListRendering() throws Throwable {
        new SimpleCase("Rendering_removeClassInListRendering.html");
    }

    public void testClearNode() throws Throwable {
        new SimpleCase("Rendering_clearNode.html");
    }

    public void testChildReplacing() throws Throwable {
        new SimpleCase("Rendering_childReplacing.html");
    }

    public void testRecursiveRendering() throws Throwable {
        new SimpleCase("Rendering_recursiveRendering.html");
    }

    public void testRenderableRendering() throws Throwable {
        new SimpleCase("Rendering_renderableRendering.html");
    }

    public void testListElementRendering() throws Throwable {
        new SimpleCase("Rendering_listElementRendering.html");
    }

    public void testListTextRendering() throws Throwable {
        new SimpleCase("Rendering_listTextRendering.html");
    }

    public void testListChildReplacing() throws Throwable {
        new SimpleCase("Rendering_listChildReplacing.html");
    }

    public void testListRecursiveRendering() throws Throwable {
        new SimpleCase("Rendering_listRecursiveRendering.html");
    }

    public void testRendererAddOperation() throws Throwable {
        new SimpleCase("Rendering_addOperation.html");
    }

    public static class TestRender {
        public Renderer elementRendering() {
            Element elem = ElementUtil.parseAsSingle((String)"<div>i am a danymic element</div>");
            Renderer render = Renderer.create((String)"*", (Element)elem);
            render.addDebugger("TestRender");
            return render;
        }

        public Renderer textRendering() {
            Renderer renderer = Renderer.create((String)"div#test", (String)"Prometheus");
            renderer.add("#testspace", "I love this game!");
            renderer.add("#testnbsp", (ElementSetter)new ChildReplacer(ElementUtil.parseAsSingle((String)"<span>three space here(&nbsp;&nbsp;&nbsp;)</span>")));
            renderer.add("#testgreatermark", "3 > 2 or 3 < 2, it's a question.");
            return renderer;
        }

        public Renderer pseudoRootRendering() {
            Renderer renderer = Renderer.create((String)":root", (String)"rendering at pseudo root");
            return renderer;
        }

        public Renderer normalAttrSetting() {
            GoThroughRenderer renderer = new GoThroughRenderer();
            renderer.add("#testadd", "+v", "2");
            renderer.add("#testaddexisted", "+v", "2");
            renderer.add("#testremovebynull", "v", null);
            renderer.add("#testremovebyClear", "v", (Object)SpecialRenderer.Clear);
            renderer.add("#testremovebyminus", "-v", "");
            renderer.add("#testremovebyaddnull", "+v", null);
            renderer.add("#testremovebyaddClear", "+v", (Object)SpecialRenderer.Clear);
            renderer.add("#testset", "v", "2");
            return renderer;
        }

        public Renderer classAttrSetting() {
            GoThroughRenderer renderer = new GoThroughRenderer();
            renderer.add("#testadd", "class", "a");
            renderer.add("#testaddexisted", "+class", "b");
            renderer.add("#testremovebynull", "class", null);
            renderer.add(".xabc", "should not be rendered");
            renderer.add("#testremovebyminus", "-class", "b");
            renderer.add("#testremovebyaddnull", "+class", null);
            renderer.add("#testset", "class", "b");
            return renderer;
        }

        public Renderer removeClassInListRendering() {
            List<Integer> list = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
            return Renderer.create((String)".item", list, (RowConvertor)new RowConvertor<Integer, Renderer>(){

                public Renderer convert(int rowIndex, Integer i) {
                    Renderer render = Renderer.create((String)".x-num", (Integer)i);
                    int idx = i % 3 + 1;
                    render.add(".x-idx-" + idx, "-class", "x-remove");
                    render.add(".x-remove", null);
                    return render;
                }
            });
        }

        public Renderer clearNode() {
            Renderer render = Renderer.create((String)"#byClearRenderer", (SpecialRenderer)SpecialRenderer.Clear);
            render.add("#byNullObj", null);
            render.add("#byNullString", (String)null);
            render.add("#byClearRenderer2", (Object)SpecialRenderer.Clear);
            return render;
        }

        public Renderer childReplacing() {
            Element elem = ElementUtil.parseAsSingle((String)"<div>i am a danymic element</div>");
            Renderer render = Renderer.create((String)"span", (ElementSetter)new ChildReplacer(elem));
            return render;
        }

        public Renderer recursiveRendering() {
            Renderer spanRender = Renderer.create((String)"span#s1", (String)"wow!");
            Renderer divRender = Renderer.create((String)"#d1", (Renderer)spanRender);
            return divRender;
        }

        public Renderer renderableRendering() {
            final HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("value", "00");
            Renderer render = Renderer.create((String)"#test", (ElementSetter)new ElementSetter(){

                public void set(Element elem) {
                    valueMap.put("value", "xx");
                }
            });
            render.add("#test", new Renderable(){

                public Renderer render() {
                    return Renderer.create((String)"*", (String)((String)valueMap.get("value")));
                }
            });
            return render;
        }

        public Renderer listTextRendering() {
            GoThroughRenderer renderer = new GoThroughRenderer();
            renderer.add("#not-exists-element", "I love this game!");
            List<String> textList = Arrays.asList("a", "b", "c");
            renderer.add("div#test-text", textList);
            List<Long> longList = Arrays.asList(1L, 2L, 3L);
            renderer.add("div#test-long", longList);
            List<Integer> integerList = Arrays.asList(10, 20, 30);
            renderer.add("div#test-integer", integerList);
            List<Boolean> booleanList = Arrays.asList(true, false, false);
            renderer.add("div#test-boolean", booleanList);
            return renderer;
        }

        public Renderer listElementRendering() {
            ArrayList<Element> list = new ArrayList<Element>();
            for (int i = 0; i <= 3; ++i) {
                Element elem = ElementUtil.parseAsSingle((String)("<span>BBB:" + i + "</span>"));
                list.add(elem);
            }
            Renderer renderer = Renderer.create((String)"div#test", list);
            return renderer;
        }

        public Renderer listChildReplacing() {
            ArrayList<Element> list = new ArrayList<Element>();
            for (int i = 0; i <= 3; ++i) {
                Element elem = ElementUtil.parseAsSingle((String)("<strong>BBB:" + i + "</strong>"));
                list.add(elem);
            }
            Renderer renderer = Renderer.create((String)"div#test", list, (RowConvertor)new RowConvertor<Element, ChildReplacer>(){

                public ChildReplacer convert(int rowIdx, Element obj) {
                    return new ChildReplacer(obj);
                }
            });
            return renderer;
        }

        public Renderer listRecursiveRendering() {
            ArrayList<String[]> list = new ArrayList<String[]>();
            for (int i = 0; i <= 3; ++i) {
                String[] sa = new String[]{"aa-" + i, "bb-" + i};
                list.add(sa);
            }
            Renderer renderer = Renderer.create((String)"div#test", list, (RowConvertor)new RowConvertor<String[], Renderer>(){

                public Renderer convert(int rowIdx, String[] obj) {
                    Renderer r = Renderer.create((String)"#s1", (String)obj[0]);
                    r.add("#s2", obj[1]);
                    return r;
                }
            });
            return renderer;
        }

        public Renderer addOperation() {
            Renderer r1 = Renderer.create((String)"#s1", (String)"r-1");
            Renderer r2 = Renderer.create((String)"#s2", (String)"r-2");
            Renderer r3 = Renderer.create((String)"#s3", (String)"r-3");
            r1.add(r2);
            r2.add(r3);
            return r2;
        }
    }
}

