/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.render;

import com.astamuse.asta4d.render.Renderer;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import com.astamuse.asta4d.test.render.infra.SimpleCase;
import com.astamuse.asta4d.test.render.infra.TimeCalculator;
import com.astamuse.asta4d.util.ElementUtil;
import com.astamuse.asta4d.util.collection.ParallelRowConvertor;
import com.astamuse.asta4d.util.collection.RowConvertor;
import com.astamuse.asta4d.util.collection.RowConvertorBuilder;
import java.util.Arrays;
import java.util.List;
import org.jsoup.nodes.Element;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class ParallelTest
extends BaseTest {
    @Test
    public void paralleListConversion() {
        TimeCalculator.shouldRunInTime(new Runnable(){

            @Override
            public void run() {
                try {
                    new SimpleCase("ParallelTest_parallelListConversion.html");
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }, 2000L);
    }

    @Test
    public void paralleListConversionLambda() {
        TimeCalculator.shouldRunInTime(new Runnable(){

            @Override
            public void run() {
                try {
                    new SimpleCase("ParallelTest_parallelListConversionLambda.html");
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }, 2000L);
    }

    @Test
    public void paralleSnippet() {
        TimeCalculator.shouldRunInTime(new Runnable(){

            @Override
            public void run() {
                try {
                    new SimpleCase("ParallelTest_parallelSnippet.html");
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }, 2000L);
    }

    public static class TestRender {
        public Renderer listTextRendering() {
            List<String> list = Arrays.asList("a", "b", "c", "d");
            Renderer renderer = Renderer.create((String)"div#test", list, (ParallelRowConvertor)new ParallelRowConvertor<String, String>(){

                public String convert(int rowIndex, String obj) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    return obj + "-sleep";
                }
            });
            return renderer;
        }

        public Renderer listTextRenderingLambda() {
            List<String> list = Arrays.asList("a", "b", "c", "d");
            Renderer renderer = Renderer.create((String)"div#test", list, (RowConvertor)RowConvertorBuilder.parallel(obj -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return obj + "-sleep";
            }));
            return renderer;
        }

        public Renderer snippetInDiv() {
            Renderer renderer = Renderer.create((String)"div", (String)"in div");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return renderer;
        }

        public Renderer snippetReplaceDiv() {
            Renderer renderer = Renderer.create((String)"div", (Element)ElementUtil.parseAsSingle((String)"<span>replace to span</span>"));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return renderer;
        }

        public Renderer snippetNormal() {
            Renderer renderer = Renderer.create((String)"div", (String)"+class", (String)"normal");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return renderer;
        }
    }
}

