/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.render;

import com.astamuse.asta4d.render.ChildReplacer;
import com.astamuse.asta4d.render.GoThroughRenderer;
import com.astamuse.asta4d.render.Renderer;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import com.astamuse.asta4d.test.render.infra.SimpleCase;
import com.astamuse.asta4d.test.render.infra.TimeCalculator;
import com.astamuse.asta4d.util.ElementUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testng.annotations.Test;

@Test
public class LambdaRenderingTest
extends BaseTest {
    public void testRemoveClassInListRendering() throws Throwable {
        new SimpleCase("LambdaRendering_removeClassInListRendering.html");
    }

    public void testRenderableRendering() throws Throwable {
        new SimpleCase("LambdaRendering_renderableRendering.html");
    }

    public void testListElementRendering() throws Throwable {
        new SimpleCase("LambdaRendering_listElementRendering.html");
    }

    public void testListTextRendering() throws Throwable {
        new SimpleCase("LambdaRendering_listTextRendering.html");
    }

    public void testListChildReplacing() throws Throwable {
        new SimpleCase("LambdaRendering_listChildReplacing.html");
    }

    public void testListRecursiveRendering() throws Throwable {
        new SimpleCase("LambdaRendering_listRecursiveRendering.html");
    }

    @Test(expectedExceptions={Exception.class}, expectedExceptionsMessageRegExp=".*not supported.*")
    public void testParallelStreamRenderingException() throws Throwable {
        new SimpleCase("LambdaRendering_parallelStreamRenderingCorrectness.html");
    }

    @Test(enabled=false)
    public void testParallelStreamRenderingCorrectness() throws Throwable {
        for (int i = 0; i < 10; ++i) {
            new SimpleCase("LambdaRendering_parallelStreamRenderingCorrectness.html");
        }
    }

    @Test(enabled=false)
    public void testParallelStreamRenderingTimeConsuming() throws Throwable {
        TimeCalculator.shouldRunInTime(() -> {
            try {
                new SimpleCase("LambdaRendering_parallelStreamRenderingTimeConsuming.html");
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }, 2000L);
    }

    public static class TestRender {
        public Renderer removeClassInListRendering() {
            List list = IntStream.range(1, 11).boxed().collect(Collectors.toList());
            return Renderer.create((String)".item", list, i -> {
                Renderer render = Renderer.create((String)".x-num", (Integer)i);
                int idx = i % 3 + 1;
                render.add(".x-idx-" + idx, "-class", "x-remove");
                render.add(".x-remove", null);
                return render;
            });
        }

        public Renderer renderableRendering() {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("value", "00");
            Renderer render = Renderer.create((String)"#test", e -> valueMap.put("value", "xx"));
            render.add("#test", () -> Renderer.create((String)"*", (String)((String)valueMap.get("value"))));
            return render;
        }

        public Renderer listTextRendering() {
            GoThroughRenderer renderer = new GoThroughRenderer();
            List<String> textList = Arrays.asList("a", "b", "c");
            renderer.add("div#test-text", textList.stream());
            List<Long> longList = Arrays.asList(10L, 20L, 30L);
            renderer.add("div#test-long", longList, (index, obj) -> obj / 10L);
            List<Integer> integerList = Arrays.asList(100, 200, 300);
            renderer.add("div#test-integer", integerList.stream().map(obj -> obj / 10));
            List<Boolean> booleanList = Arrays.asList(true, false, false);
            renderer.add("div#test-boolean", booleanList, obj -> obj != false);
            return renderer;
        }

        public Renderer listElementRendering() {
            Renderer renderer = Renderer.create((String)"div#test", IntStream.range(0, 4).mapToObj(i -> ElementUtil.parseAsSingle((String)("<span>BBB:" + i + "</span>"))));
            return renderer;
        }

        public Renderer listChildReplacing() {
            List list = IntStream.range(0, 4).boxed().collect(Collectors.toList());
            Renderer renderer = Renderer.create((String)"div#test", list, i -> new ChildReplacer(ElementUtil.parseAsSingle((String)("<strong>BBB:" + i + "</strong>"))));
            return renderer;
        }

        public Renderer listRecursiveRendering() {
            ArrayList<String[]> list = new ArrayList<String[]>();
            for (int i = 0; i <= 3; ++i) {
                String[] sa = new String[]{"aa-" + i, "bb-" + i};
                list.add(sa);
            }
            Renderer renderer = Renderer.create((String)"div#test", list, obj -> {
                Renderer r = Renderer.create((String)"#s1", (String)obj[0]);
                r.add("#s2", obj[1]);
                return r;
            });
            return renderer;
        }

        public Renderer parallelStreamRenderingCorrectness() {
            GoThroughRenderer renderer = new GoThroughRenderer();
            List<String> textList = Arrays.asList("a", "b", "c", "d", "e", "f", "g", "h", "i", "j");
            renderer.add("div#test-text", textList.parallelStream().map(t -> t));
            return renderer;
        }

        public Renderer parallelStreamRenderingTimeConsuming() {
            GoThroughRenderer renderer = new GoThroughRenderer();
            List<String> textList = Arrays.asList("a", "b", "c");
            renderer.add("div#test-text", textList.parallelStream().map(t -> {
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return t;
            }));
            return renderer;
        }
    }
}

