/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.render;

import com.astamuse.asta4d.Context;
import com.astamuse.asta4d.data.annotation.ContextData;
import com.astamuse.asta4d.render.GoThroughRenderer;
import com.astamuse.asta4d.render.Renderer;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import com.astamuse.asta4d.test.render.infra.SimpleCase;

public class InjectTest
extends BaseTest {
    public void testMethodDefaultSearch() throws Throwable {
        Context context = Context.getCurrentThreadContext();
        context.setData("default", "pv", (Object)"pv-value at context");
        context.setData("default", "cv", (Object)"cv-value at context");
        context.setData("global", "cv", (Object)"cv-value at global");
        context.setData("global", "gv", (Object)"gv-value");
        new SimpleCase("Inject_testMethodDefaultSearch.html");
    }

    public void testMethodScopeSearch() throws Throwable {
        Context context = Context.getCurrentThreadContext();
        context.setData("default", "av", (Object)"av-value at context");
        context.setData("default", "pv", (Object)"pv-value at context");
        context.setData("default", "cv", (Object)"cv-value at context");
        context.setData("global", "cv", (Object)"cv-value at global");
        context.setData("default", "gv", (Object)"gv-value at context");
        context.setData("global", "gv", (Object)"gv-value at global");
        new SimpleCase("Inject_testMethodScopeSearch.html");
    }

    public void testMethodNameSearch() throws Throwable {
        Context context = Context.getCurrentThreadContext();
        context.setData("default", "cv", (Object)"cv-value");
        context.setData("default", "cv-r", (Object)"cv-value for name replace");
        context.setData("global", "gv-r", (Object)"gv-value for name replace");
        context.setData("global", "gv", (Object)"gv-value");
        new SimpleCase("Inject_testMethodNameSearch.html");
    }

    public void testMethodTypeConvertor() throws Throwable {
        Context context = Context.getCurrentThreadContext();
        context.setData("default", "intvalue", (Object)"222");
        context.setData("default", "longvalue", (Object)"333");
        context.setData("default", "boolvalue", (Object)"false");
        new SimpleCase("Inject_testMethodTypeConvertor.html");
    }

    public void testInstanceDefaultSearch() throws Throwable {
        Context context = Context.getCurrentThreadContext();
        context.setData("default", "cv", (Object)"cv-value at context");
        context.setData("global", "cv", (Object)"cv-value at global");
        context.setData("global", "gv", (Object)"gv-value");
        new SimpleCase("Inject_testInstanceDefaultSearch.html");
    }

    public void testInstanceScopeSearch() throws Throwable {
        Context context = Context.getCurrentThreadContext();
        context.setData("default", "cv", (Object)"cv-value at context");
        context.setData("global", "cv", (Object)"cv-value at global");
        context.setData("default", "gv", (Object)"gv-value at context");
        context.setData("global", "gv", (Object)"gv-value at global");
        new SimpleCase("Inject_testInstanceScopeSearch.html");
    }

    public void testInstanceNameSearch() throws Throwable {
        Context context = Context.getCurrentThreadContext();
        context.setData("default", "cv", (Object)"cv-value");
        context.setData("default", "cv-r", (Object)"cv-value for name replace");
        context.setData("global", "gv", (Object)"gv-value");
        context.setData("global", "gv-r", (Object)"gv-value for name replace");
        new SimpleCase("Inject_testInstanceNameSearch.html");
    }

    public void testInstanceTypeConvertor() throws Throwable {
        Context context = Context.getCurrentThreadContext();
        context.setData("default", "intvalue", (Object)"111");
        context.setData("default", "longvalue", (Object)"555");
        context.setData("default", "boolvalue", (Object)"true");
        new SimpleCase("Inject_testInstanceTypeConvertor.html");
    }

    public static class InstanceTypeConvertorRender {
        @ContextData
        private int intvalue;
        @ContextData
        private long longvalue;
        @ContextData
        private boolean boolvalue;

        public Renderer render() {
            Renderer render = Renderer.create((String)"#intvalue", (Integer)this.intvalue);
            render.add("#longvalue", Long.valueOf(this.longvalue));
            render.add("#boolvalue", Boolean.valueOf(this.boolvalue));
            return render;
        }
    }

    public static class InstaneNameSearchRender {
        @ContextData(name="cv-r")
        private String cv;
        private String gv;

        public Renderer render() {
            GoThroughRenderer render = new GoThroughRenderer();
            render.add("#cv-value", this.cv);
            render.add("#gv-value", this.gv);
            return render;
        }

        public String getGv() {
            return this.gv;
        }

        @ContextData(name="gv-r")
        public void setGv(String gv) {
            this.gv = gv;
        }
    }

    public static class InstaneScopeSearchRender {
        @ContextData(scope="global")
        private String cv;
        private String gv;

        public Renderer render() {
            GoThroughRenderer render = new GoThroughRenderer();
            render.add("#cv-value", this.cv);
            render.add("#gv-value", this.gv);
            return render;
        }

        public String getGv() {
            return this.gv;
        }

        @ContextData(scope="global")
        public void setGv(String gv) {
            this.gv = gv;
        }
    }

    public static class InstaneDefaultSearchRender {
        @ContextData
        private String cv;
        private String gv;

        public Renderer render() {
            GoThroughRenderer render = new GoThroughRenderer();
            render.add("#cv-value", this.cv);
            render.add("#gv-value", this.gv);
            return render;
        }

        public String getGv() {
            return this.gv;
        }

        @ContextData
        public void setGv(String gv) {
            this.gv = gv;
        }
    }

    public static class TestRender {
        public Renderer methodDefaultSearch(String av, String pv, String cv, String gv) {
            Renderer render = Renderer.create((String)"#av-value", (String)av);
            render.add("#pv-value", pv);
            render.add("#cv-value", cv);
            render.add("#gv-value", gv);
            return render;
        }

        public Renderer methodScopeSearch(@ContextData(scope="default") String av, @ContextData(scope="default") String pv, @ContextData(scope="global") String cv, @ContextData(scope="global") String gv) {
            Renderer render = Renderer.create((String)"#av-value", (String)av);
            render.add("#pv-value", pv);
            render.add("#cv-value", cv);
            render.add("#gv-value", gv);
            return render;
        }

        public Renderer methodNameSearch(@ContextData(name="av-r") String av, @ContextData(name="cv-r") String cv, @ContextData(name="gv-r") String gv) {
            Renderer render = Renderer.create((String)"#av-value", (String)av);
            render.add("#cv-value", cv);
            render.add("#gv-value", gv);
            return render;
        }

        public Renderer methodTypeConvertor(int intvalue, long longvalue, boolean boolvalue) {
            Renderer render = Renderer.create((String)"#intvalue", (Integer)intvalue);
            render.add("#longvalue", Long.valueOf(longvalue));
            render.add("#boolvalue", Boolean.valueOf(boolvalue));
            return render;
        }
    }
}

