/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.render;

import com.astamuse.asta4d.Configuration;
import com.astamuse.asta4d.Context;
import com.astamuse.asta4d.render.GoThroughRenderer;
import com.astamuse.asta4d.render.Renderer;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import com.astamuse.asta4d.test.render.infra.SimpleCase;
import com.astamuse.asta4d.util.i18n.I18nMessageHelper;
import com.astamuse.asta4d.util.i18n.I18nMessageHelperTypeAssistant;
import com.astamuse.asta4d.util.i18n.MappedParamI18nMessageHelper;
import com.astamuse.asta4d.util.i18n.OrderedParamI18nMessageHelper;
import com.astamuse.asta4d.util.i18n.formatter.ApacheStrSubstitutorFormatter;
import com.astamuse.asta4d.util.i18n.formatter.JDKMessageFormatFormatter;
import com.astamuse.asta4d.util.i18n.formatter.MappedValueFormatter;
import com.astamuse.asta4d.util.i18n.formatter.OrderedValueFormatter;
import com.astamuse.asta4d.util.i18n.formatter.SymbolPlaceholderFormatter;
import com.astamuse.asta4d.util.i18n.pattern.JDKResourceBundleMessagePatternRetriever;
import java.util.Locale;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ExternalizeMessageTest
extends BaseTest {
    @BeforeClass
    public void setDefaultLocale() {
        Locale.setDefault(Locale.ROOT);
    }

    @Test
    public void externalizeMessage_DefaultMsg() throws Throwable {
        Context.getCurrentThreadContext().setCurrentLocale(Locale.US);
        ExternalizeMessageTest.setUpResourceBundleManager("symbol_placeholder_messages", (I18nMessageHelper)new MappedParamI18nMessageHelper((MappedValueFormatter)new ApacheStrSubstitutorFormatter()));
        new SimpleCase("ExternalizeMessage_DefaultMsg.html", "ExternalizeMessage_DefaultMsg.html");
    }

    @Test
    public void externalizeMessage_SymbolPlaceholder_us() throws Throwable {
        Context.getCurrentThreadContext().setCurrentLocale(Locale.US);
        ExternalizeMessageTest.setUpResourceBundleManager("symbol_placeholder_messages", (I18nMessageHelper)new OrderedParamI18nMessageHelper((OrderedValueFormatter)new SymbolPlaceholderFormatter()));
        new SimpleCase("ExternalizeMessage_NumberedParamKey.html", "ExternalizeMessage_SymbolPlaceholder_us.html");
    }

    @Test
    public void externalizeMessage_SymbolPlaceholder_ja() throws Throwable {
        Context.getCurrentThreadContext().setCurrentLocale(Locale.JAPAN);
        ExternalizeMessageTest.setUpResourceBundleManager("symbol_placeholder_messages", (I18nMessageHelper)new OrderedParamI18nMessageHelper((OrderedValueFormatter)new SymbolPlaceholderFormatter()));
        new SimpleCase("ExternalizeMessage_NumberedParamKey.html", "ExternalizeMessage_SymbolPlaceholder_ja.html");
    }

    @Test
    public void externalizeMessage_JDKMessageFormat_us() throws Throwable {
        Context.getCurrentThreadContext().setCurrentLocale(Locale.US);
        ExternalizeMessageTest.setUpResourceBundleManager("number_placeholder_messages", (I18nMessageHelper)new OrderedParamI18nMessageHelper((OrderedValueFormatter)new JDKMessageFormatFormatter()));
        new SimpleCase("ExternalizeMessage_NumberedParamKey.html", "ExternalizeMessage_SymbolPlaceholder_us.html");
    }

    @Test
    public void externalizeMessage_JDKMessageFormat_ja() throws Throwable {
        Context.getCurrentThreadContext().setCurrentLocale(Locale.JAPAN);
        ExternalizeMessageTest.setUpResourceBundleManager("number_placeholder_messages", (I18nMessageHelper)new OrderedParamI18nMessageHelper((OrderedValueFormatter)new JDKMessageFormatFormatter()));
        new SimpleCase("ExternalizeMessage_NumberedParamKey.html", "ExternalizeMessage_SymbolPlaceholder_ja.html");
    }

    @Test
    public void externalizeMessage_NamedPlaceholder_us() throws Throwable {
        Context.getCurrentThreadContext().setCurrentLocale(Locale.US);
        ExternalizeMessageTest.setUpResourceBundleManager("named_placeholder_messages", (I18nMessageHelper)new MappedParamI18nMessageHelper((MappedValueFormatter)new ApacheStrSubstitutorFormatter()));
        new SimpleCase("ExternalizeMessage_NamedParamKey.html", "ExternalizeMessage_SymbolPlaceholder_us.html");
    }

    @Test
    public void externalizeMessage_NamedPlaceholder_ja() throws Throwable {
        Context.getCurrentThreadContext().setCurrentLocale(Locale.JAPAN);
        ExternalizeMessageTest.setUpResourceBundleManager("named_placeholder_messages", (I18nMessageHelper)new MappedParamI18nMessageHelper((MappedValueFormatter)new ApacheStrSubstitutorFormatter()));
        new SimpleCase("ExternalizeMessage_NamedParamKey.html", "ExternalizeMessage_SymbolPlaceholder_ja.html");
    }

    private static void setUpResourceBundleManager(String fileName, I18nMessageHelper helper) {
        Configuration configuration = Configuration.getConfiguration();
        configuration.setI18nMessageHelper(helper);
        JDKResourceBundleMessagePatternRetriever retriever = (JDKResourceBundleMessagePatternRetriever)configuration.getI18nMessageHelper().getMessagePatternRetriever();
        retriever.setResourceNames(new String[]{"com.astamuse.asta4d.test.render.messages." + fileName});
        System.setProperty("I18nMessageHelperTypeAssistant.Test", "xxx");
        I18nMessageHelperTypeAssistant.reCreateInternalInstance();
    }

    public static class TestSnippet {
        public Renderer setWeatherreportInfo_NumberedParamKey() {
            GoThroughRenderer renderer = new GoThroughRenderer();
            renderer.add("afd|msg", "p0", "Tomorrow");
            renderer.add("afd|msg", "p1", "sunny");
            return renderer;
        }

        public Renderer setWeatherreportInfo_NamedParamKey() {
            GoThroughRenderer renderer = new GoThroughRenderer();
            renderer.add("afd|msg", "date", "Tomorrow");
            renderer.add("afd|msg", "weather", "sunny");
            return renderer;
        }
    }
}

