/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.render;

import com.astamuse.asta4d.data.ContextBindData;
import com.astamuse.asta4d.render.Renderer;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import com.astamuse.asta4d.test.render.infra.SimpleCase;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class ContextBindDataTest
extends BaseTest {
    private static final AtomicInteger NonParallelRenderCounter = new AtomicInteger();
    private static final AtomicInteger ParallelRenderCounter = new AtomicInteger();

    public void testNonParallel() throws Throwable {
        new SimpleCase("ContextBindData_nonParallel.html");
    }

    public void testParallel() throws Throwable {
        for (int i = 0; i < 20; ++i) {
            new SimpleCase("ContextBindData_parallel.html");
        }
    }

    static /* synthetic */ AtomicInteger access$000() {
        return NonParallelRenderCounter;
    }

    static /* synthetic */ AtomicInteger access$200() {
        return ParallelRenderCounter;
    }

    public static class ParallelRender {
        private AtomicInteger counter = ContextBindDataTest.access$200();
        private ContextBindData<Integer> data = new ContextBindData<Integer>(true){

            protected Integer buildData() {
                return counter.incrementAndGet();
            }
        };

        public Renderer render() {
            return Renderer.create((String)"*", (Integer)((Integer)this.data.get()));
        }
    }

    public static class NonParallelRender {
        private AtomicInteger coutner = ContextBindDataTest.access$000();
        private ContextBindData<Integer> data = new ContextBindData<Integer>(){

            protected Integer buildData() {
                return coutner.incrementAndGet();
            }
        };

        public Renderer render() {
            return Renderer.create((String)"*", (Integer)((Integer)this.data.get()));
        }
    }
}

