/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.render;

import com.astamuse.asta4d.Context;
import com.astamuse.asta4d.data.annotation.ContextData;
import com.astamuse.asta4d.render.Renderer;
import com.astamuse.asta4d.render.SpecialRenderer;
import com.astamuse.asta4d.snippet.SnippetInvokeException;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import com.astamuse.asta4d.test.render.infra.SimpleCase;
import com.astamuse.asta4d.util.ElementUtil;
import org.jsoup.nodes.Element;
import org.testng.annotations.Test;

@Test
public class AdvancedSnippetTest
extends BaseTest {
    public void testDeletedNestedSnippet() throws Throwable {
        new SimpleCase("AdvancedSnippet_deletedNestedSnippet.html");
    }

    public void testNestedSnippet() throws Throwable {
        new SimpleCase("AdvancedSnippet_nestedSnippet.html");
    }

    public void testNestedEmbed() throws Throwable {
        new SimpleCase("AdvancedSnippet_nestedEmbed.html");
    }

    public void testOverrideRenderMethod() throws Throwable {
        new SimpleCase("AdvancedSnippet_overrideRenderMethod.html");
    }

    @Test(expectedExceptions={SnippetInvokeException.class}, expectedExceptionsMessageRegExp=".*Found data\\(ads\\) cannot be coverted from \\[class java\\.lang\\.String\\] to \\[class java\\.lang\\.Integer\\].*")
    public void testInitializingFailedSnippet() throws Throwable {
        Context.getCurrentThreadContext().setData("value", (Object)"ads");
        new SimpleCase("AdvancedSnippet_initializingFailed.html");
    }

    public static class InitializingFailedSnippet {
        @ContextData
        int value;

        public Renderer render() {
            return Renderer.create();
        }
    }

    public static class ChildSnippet
    extends MiddleSnippet {
        @Override
        public Renderer render() {
            return Renderer.create((String)"p", (String)"child");
        }

        @Override
        public Renderer rx(@ContextData(name="xxx") String x) {
            return Renderer.create((String)"p", (String)"child");
        }
    }

    public static class MiddleSnippet
    extends ParentSnippet {
    }

    public static class ParentSnippet {
        public Renderer render() {
            return Renderer.create((String)"p", (String)"parent");
        }

        public Renderer rx(String x) {
            return Renderer.create((String)"p", (String)"parent");
        }
    }

    public static class TestSnippet {
        public Renderer nestedSnippet_outer() {
            Renderer render = Renderer.create((String)"#pv", (String)"666");
            render.add("#inner", "value", "777");
            return render;
        }

        public Renderer nestedSnippet_inner(String value) {
            return Renderer.create((String)"#pv", (String)value);
        }

        public Renderer deletedNestedSnippet_outer() {
            return Renderer.create((String)"#inner", (SpecialRenderer)SpecialRenderer.Clear);
        }

        public Renderer nestedEmbed(String value) {
            return Renderer.create((String)"#kv", (String)value);
        }

        public Renderer dynamicSnippetSub() {
            Renderer render = Renderer.create((String)"*", (Element)ElementUtil.text((String)"ff"));
            return render;
        }
    }
}

