/*
 * Decompiled with CFR 0.152.
 */
package com.astamuse.asta4d.test.render;

import com.astamuse.asta4d.render.ElementNotFoundHandler;
import com.astamuse.asta4d.render.ElementSetter;
import com.astamuse.asta4d.render.GoThroughRenderer;
import com.astamuse.asta4d.render.Renderer;
import com.astamuse.asta4d.test.render.infra.BaseTest;
import com.astamuse.asta4d.test.render.infra.SimpleCase;
import com.astamuse.asta4d.util.ElementUtil;
import com.astamuse.asta4d.util.collection.RowConvertor;
import com.astamuse.asta4d.util.collection.RowRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jsoup.nodes.Element;
import org.testng.annotations.Test;

public class AdvancedRenderingTest
extends BaseTest {
    @Test
    public void testPseudoRootRenderingOnFackedGroup() throws Throwable {
        new SimpleCase("AdvancedRendering_pseudoRootRendering.html");
    }

    @Test
    public void testContinualSelectAll() throws Throwable {
        new SimpleCase("AdvancedRendering_continualSelectAll.html");
    }

    @Test
    public void testDataRef() throws Throwable {
        new SimpleCase("AdvancedRendering_dataRef.html");
    }

    public static class TestRender {
        public Renderer continualSelectAll() {
            GoThroughRenderer render = new GoThroughRenderer();
            Element elem = ElementUtil.parseAsSingle((String)"<div>i am a danymic element</div>");
            Renderer repElem = Renderer.create((String)"*", (Element)elem);
            repElem.addDebugger("after rep elem");
            repElem.add("*", "replacetext");
            repElem.addDebugger("after rep text");
            render.addDebugger("before d1");
            render.add("#d1", repElem);
            render.addDebugger("after d1");
            Renderer attrSet = Renderer.create((String)"div", (String)"a", (String)"b");
            attrSet.add("#d3[a=b]", "+class", "tc");
            render.addDebugger("before d2");
            render.add("#d2", attrSet);
            render.addDebugger("after d2");
            return render;
        }

        public Renderer setAnyTypeOuter(int count) {
            GoThroughRenderer render = new GoThroughRenderer();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                list.add("listParam" + i);
            }
            render.add("#outerDiv", "outerValue");
            render.add("#inner", "outerList", list);
            render.add("#outer", "-count", null);
            return render;
        }

        public Renderer setAnyTypeInner(List<String> outerList) {
            GoThroughRenderer render = new GoThroughRenderer();
            render.add("#innerList > li", outerList);
            render.add("#inner", "-outerList", null);
            return render;
        }

        public Renderer pseudoRootRenderingWithNestedSnippet_outer() {
            Renderer renderer = Renderer.create((String)"#inner", Arrays.asList(1, 2, 3), (RowConvertor)new RowRenderer<Integer>(){

                public Renderer convert(int rowIndex, Integer row) {
                    return Renderer.create((String)":root", (String)"value", (Integer)row);
                }
            });
            return renderer;
        }

        public Renderer pseudoRootRenderingWithNestedSnippet_inner(String value) {
            Renderer renderer = Renderer.create((String)"#v", (String)value);
            renderer.add(":root", new ElementSetter(){

                public void set(Element elem) {
                    elem.appendText("test-append");
                }
            });
            return renderer;
        }

        public Renderer pseudoRootRenderingOnFackedGroup() {
            Renderer renderer = Renderer.create((String)":root", (Renderer)Renderer.create((String)"div", (String)"t1"));
            renderer.add(":root", Renderer.create((String)"div", (String)"t2"));
            return renderer;
        }

        public Renderer pseudoRootRenderingWithElementNotFoundHandler() {
            Renderer renderer = Renderer.create((String)":root", (Renderer)Renderer.create((String)"div", (String)"t1"));
            renderer.add((Renderer)new ElementNotFoundHandler("span"){

                public Renderer alternativeRenderer() {
                    return Renderer.create((String)":root", (Renderer)Renderer.create((String)"div", (String)"t2"));
                }
            });
            renderer.add(":root", Renderer.create((String)"div", (String)"t3"));
            return renderer;
        }
    }
}

