/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairvector.params;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.util.SafeEncoder;

public class HscanParams {
    private static final String MATCH = "MATCH";
    private static final String COUNT = "COUNT";
    private static final String VECTOR = "VECTOR";
    private static final String MAX_DIST = "MAX_DIST";
    private static final String FILTER = "FILTER";
    private final Map<String, ByteBuffer> params = new HashMap<String, ByteBuffer>();
    public static final String SCAN_POINTER_START = String.valueOf(0);
    public static final byte[] SCAN_POINTER_START_BINARY = SafeEncoder.encode((String)SCAN_POINTER_START);

    public HscanParams match(byte[] pattern) {
        this.params.put(MATCH, ByteBuffer.wrap(pattern));
        return this;
    }

    public HscanParams match(String pattern) {
        this.params.put(MATCH, ByteBuffer.wrap(SafeEncoder.encode((String)pattern)));
        return this;
    }

    public HscanParams count(Integer count) {
        this.params.put(COUNT, ByteBuffer.wrap(Protocol.toByteArray((int)count)));
        return this;
    }

    public HscanParams vector(byte[] vector) {
        this.params.put(VECTOR, ByteBuffer.wrap(vector));
        return this;
    }

    public HscanParams vector(String vector) {
        this.params.put(VECTOR, ByteBuffer.wrap(SafeEncoder.encode((String)vector)));
        return this;
    }

    public HscanParams max_dist(float max_dist) {
        this.params.put(MAX_DIST, ByteBuffer.wrap(Protocol.toByteArray((double)max_dist)));
        return this;
    }

    public HscanParams filter(String filter) {
        this.params.put(FILTER, ByteBuffer.wrap(SafeEncoder.encode((String)filter)));
        return this;
    }

    public Collection<byte[]> getParams() {
        ArrayList<byte[]> paramsList = new ArrayList<byte[]>(this.params.size());
        for (Map.Entry<String, ByteBuffer> param : this.params.entrySet()) {
            paramsList.add(SafeEncoder.encode((String)param.getKey()));
            paramsList.add(param.getValue().array());
        }
        return Collections.unmodifiableCollection(paramsList);
    }

    byte[] binaryMatch() {
        return this.params.containsKey(MATCH) ? this.params.get(MATCH).array() : null;
    }

    String match() {
        return this.params.containsKey(MATCH) ? new String(this.params.get(MATCH).array()) : null;
    }

    Integer count() {
        return this.params.containsKey(COUNT) ? Integer.valueOf(this.params.get(COUNT).getInt()) : null;
    }
}

