/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairvector;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.jedis3.ScanResult;
import com.aliyun.tair.tairvector.factory.VectorBuilderFactory;
import com.aliyun.tair.tairvector.params.DistanceMethod;
import com.aliyun.tair.tairvector.params.HscanParams;
import com.aliyun.tair.tairvector.params.IndexAlgorithm;
import com.aliyun.tair.util.JoinParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairVectorCluster {
    private JedisCluster jc;

    public TairVectorCluster(JedisCluster jc) {
        this.jc = jc;
    }

    public void quit() {
        if (this.jc != null) {
            this.jc.close();
        }
    }

    public String tvscreateindex(String index, int dims, IndexAlgorithm algorithm, DistanceMethod method, String ... attrs) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSCREATEINDEX, JoinParameters.joinParameters(SafeEncoder.encode((String)index), Protocol.toByteArray((int)dims), SafeEncoder.encode((String)algorithm.name()), SafeEncoder.encode((String)method.name()), SafeEncoder.encodeMany((String[])attrs)));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public byte[] tvscreateindex(byte[] index, int dims, IndexAlgorithm algorithm, DistanceMethod method, byte[] ... params) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSCREATEINDEX, JoinParameters.joinParameters(index, Protocol.toByteArray((int)dims), SafeEncoder.encode((String)algorithm.name()), SafeEncoder.encode((String)method.name()), params));
        return (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
    }

    public Map<String, String> tvsgetindex(String index) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSGETINDEX, (byte[][])new byte[][]{SafeEncoder.encode((String)index)});
        return (Map)BuilderFactory.STRING_MAP.build(obj);
    }

    public Map<byte[], byte[]> tvsgetindex(byte[] index) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSGETINDEX, (byte[][])new byte[][]{index});
        return (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build(obj);
    }

    public Long tvsdelindex(String index) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSDELINDEX, (byte[][])new byte[][]{SafeEncoder.encode((String)index)});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long tvsdelindex(byte[] index) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSDELINDEX, (byte[][])new byte[][]{index});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public ScanResult<String> tvsscanindex(Long cursor, HscanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(Protocol.toByteArray((long)cursor));
        args.addAll(params.getParams());
        Object obj = this.jc.sendCommand(Protocol.toByteArray((long)cursor), (ProtocolCommand)ModuleCommand.TVSSCANINDEX, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return (ScanResult)VectorBuilderFactory.SCAN_CURSOR_STRING.build(obj);
    }

    public Long tvshset(String index, String entityid, String vector, String ... params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSHSET, JoinParameters.joinParameters(SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid), SafeEncoder.encode((String)"VECTOR"), SafeEncoder.encode((String)vector), SafeEncoder.encodeMany((String[])params)));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long tvshset(byte[] index, byte[] entityid, byte[] vector, byte[] ... params) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSHSET, JoinParameters.joinParameters(index, entityid, SafeEncoder.encode((String)"VECTOR"), vector, params));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Map<String, String> tvshgetall(String index, String entityid) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSHGETALL, (byte[][])new byte[][]{SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid)});
        return (Map)BuilderFactory.STRING_MAP.build(obj);
    }

    public Map<byte[], byte[]> tvshgetall(byte[] index, byte[] entityid) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSHGETALL, (byte[][])new byte[][]{index, entityid});
        return (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build(obj);
    }

    public List<String> tvshmget(String index, String entityid, String ... attrs) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSHMGET, JoinParameters.joinParameters(SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid), SafeEncoder.encodeMany((String[])attrs)));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> tvshmget(byte[] index, byte[] entityid, byte[] ... attrs) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSHMGET, JoinParameters.joinParameters(index, entityid, attrs));
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public Long tvsdel(String index, String entityid) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSDEL, (byte[][])new byte[][]{SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid)});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long tvsdel(byte[] index, byte[] entityid) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSDEL, (byte[][])new byte[][]{index, entityid});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long tvsdel(String index, String ... entityids) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSDEL, JoinParameters.joinParameters(SafeEncoder.encode((String)index), SafeEncoder.encodeMany((String[])entityids)));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long tvsdel(byte[] index, byte[] ... entityids) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSDEL, JoinParameters.joinParameters(index, entityids));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long tvshdel(String index, String entityid, String ... attrs) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSHDEL, JoinParameters.joinParameters(SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid), SafeEncoder.encodeMany((String[])attrs)));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long tvshdel(byte[] index, byte[] entityid, byte[] ... attrs) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSHDEL, JoinParameters.joinParameters(index, entityid, attrs));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public ScanResult<String> tvsscan(String index, Long cursor, HscanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)index));
        args.add(Protocol.toByteArray((long)cursor));
        args.addAll(params.getParams());
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return (ScanResult)VectorBuilderFactory.SCAN_CURSOR_STRING.build(obj);
    }

    public ScanResult<byte[]> tvsscan(byte[] index, Long cursor, HscanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(index);
        args.add(Protocol.toByteArray((long)cursor));
        args.addAll(params.getParams());
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSSCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return (ScanResult)VectorBuilderFactory.SCAN_CURSOR_BYTE.build(obj);
    }

    public VectorBuilderFactory.Knn<String> tvsknnsearch(String index, Long topn, String vector, String ... params) {
        return this.tvsknnsearchfilter(index, topn, vector, "", params);
    }

    public VectorBuilderFactory.Knn<byte[]> tvsknnsearch(byte[] index, Long topn, byte[] vector, byte[] ... params) {
        return this.tvsknnsearchfilter(index, topn, vector, SafeEncoder.encode((String)""), params);
    }

    public VectorBuilderFactory.Knn<String> tvsknnsearchfilter(String index, Long topn, String vector, String pattern, String ... params) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSKNNSEARCH, JoinParameters.joinParameters(SafeEncoder.encode((String)index), Protocol.toByteArray((long)topn), SafeEncoder.encode((String)vector), SafeEncoder.encode((String)pattern), SafeEncoder.encodeMany((String[])params)));
        return (VectorBuilderFactory.Knn)VectorBuilderFactory.STRING_KNN_RESULT.build(obj);
    }

    public VectorBuilderFactory.Knn<byte[]> tvsknnsearchfilter(byte[] index, Long topn, byte[] vector, byte[] pattern, byte[] ... params) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSKNNSEARCH, JoinParameters.joinParameters(index, Protocol.toByteArray((long)topn), vector, pattern, params));
        return (VectorBuilderFactory.Knn)VectorBuilderFactory.BYTE_KNN_RESULT.build(obj);
    }

    public VectorBuilderFactory.KnnField<String> tvsknnsearchfield(String index, Long topn, String vector, Collection<String> fields, String ... params) {
        return this.tvsknnsearchfilterfield(index, topn, vector, fields, "", params);
    }

    public VectorBuilderFactory.KnnField<byte[]> tvsknnsearchfield(byte[] index, Long topn, byte[] vector, Collection<byte[]> fields, byte[] ... params) {
        return this.tvsknnsearchfilterfield(index, topn, vector, fields, SafeEncoder.encode((String)""), params);
    }

    public VectorBuilderFactory.KnnField<String> tvsknnsearchfilterfield(String index, Long topn, String vector, Collection<String> fields, String pattern, String ... params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)index));
        args.add(Protocol.toByteArray((long)topn));
        args.add(SafeEncoder.encode((String)vector));
        args.add(Protocol.toByteArray((int)fields.size()));
        if (!fields.isEmpty()) {
            args.addAll(fields.stream().map(SafeEncoder::encode).collect(Collectors.toList()));
        }
        args.add(SafeEncoder.encode((String)pattern));
        args.addAll(Arrays.stream(params).map(SafeEncoder::encode).collect(Collectors.toList()));
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSKNNSEARCHFIELD, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return (VectorBuilderFactory.KnnField)VectorBuilderFactory.STRING_KNNFIELD_RESULT.build(obj);
    }

    public VectorBuilderFactory.KnnField<byte[]> tvsknnsearchfilterfield(byte[] index, Long topn, byte[] vector, Collection<byte[]> fields, byte[] pattern, byte[] ... params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(index);
        args.add(Protocol.toByteArray((long)topn));
        args.add(vector);
        args.add(Protocol.toByteArray((int)fields.size()));
        if (!fields.isEmpty()) {
            args.addAll(fields);
        }
        args.add(pattern);
        args.addAll(Arrays.stream(params).collect(Collectors.toList()));
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSKNNSEARCHFIELD, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return (VectorBuilderFactory.KnnField)VectorBuilderFactory.BYTE_KNNFIELD_RESULT.build(obj);
    }

    public Collection<VectorBuilderFactory.Knn<String>> tvsmknnsearch(String index, Long topn, Collection<String> vectors, String ... params) {
        return this.tvsmknnsearchfilter(index, topn, vectors, "", params);
    }

    public Collection<VectorBuilderFactory.Knn<byte[]>> tvsmknnsearch(byte[] index, Long topn, Collection<byte[]> vectors, byte[] ... params) {
        return this.tvsmknnsearchfilter(index, topn, vectors, SafeEncoder.encode((String)""), params);
    }

    public Collection<VectorBuilderFactory.Knn<String>> tvsmknnsearchfilter(String index, Long topn, Collection<String> vectors, String pattern, String ... params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)index));
        args.add(Protocol.toByteArray((long)topn));
        args.add(Protocol.toByteArray((int)vectors.size()));
        args.addAll(vectors.stream().map(vector -> SafeEncoder.encode((String)vector)).collect(Collectors.toList()));
        args.add(SafeEncoder.encode((String)pattern));
        args.addAll(Arrays.stream(params).map(str -> SafeEncoder.encode((String)str)).collect(Collectors.toList()));
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSMKNNSEARCH, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return (Collection)VectorBuilderFactory.STRING_KNN_BATCH_RESULT.build(obj);
    }

    public Collection<VectorBuilderFactory.Knn<byte[]>> tvsmknnsearchfilter(byte[] index, Long topn, Collection<byte[]> vectors, byte[] pattern, byte[] ... params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(index);
        args.add(Protocol.toByteArray((long)topn));
        args.add(Protocol.toByteArray((int)vectors.size()));
        args.addAll(vectors);
        args.add(pattern);
        args.addAll(Arrays.stream(params).collect(Collectors.toList()));
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSMKNNSEARCH, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return (Collection)VectorBuilderFactory.BYTE_KNN_BATCH_RESULT.build(obj);
    }

    public VectorBuilderFactory.Knn<String> tvsmindexknnsearch(Collection<String> indexs, Long topn, String vector, String ... params) {
        return null;
    }

    public VectorBuilderFactory.Knn<byte[]> tvsmindexknnsearch(Collection<byte[]> indexs, Long topn, byte[] vector, byte[] ... params) {
        return null;
    }

    public Collection<VectorBuilderFactory.Knn<String>> tvsmindexmknnsearch(Collection<String> indexs, Long topn, Collection<String> vectors, String ... params) {
        return null;
    }

    public Collection<VectorBuilderFactory.Knn<byte[]>> tvsmindexmknnsearch(Collection<byte[]> indexs, Long topn, Collection<byte[]> vectors, byte[] ... params) {
        return null;
    }

    public VectorBuilderFactory.Knn<String> tvsmindexknnsearchfilter(Collection<String> indexs, Long topn, String vector, String pattern, String ... params) {
        return null;
    }

    public VectorBuilderFactory.Knn<byte[]> tvsmindexknnsearchfilter(Collection<byte[]> indexs, Long topn, byte[] vector, byte[] pattern, byte[] ... params) {
        return null;
    }

    public Collection<VectorBuilderFactory.Knn<String>> tvsmindexmknnsearchfilter(Collection<String> indexs, Long topn, Collection<String> vectors, String pattern, String ... params) {
        return null;
    }

    public Collection<VectorBuilderFactory.Knn<byte[]>> tvsmindexmknnsearchfilter(Collection<byte[]> indexs, Long topn, Collection<byte[]> vectors, byte[] pattern, byte[] ... params) {
        return null;
    }

    public VectorBuilderFactory.KnnField<String> tvsmindexknnsearchField(Collection<String> indexs, Long topn, String vector, Collection<String> fields, String ... params) {
        return null;
    }

    public VectorBuilderFactory.KnnField<byte[]> tvsmindexknnsearchField(Collection<byte[]> indexs, Long topn, byte[] vector, Collection<byte[]> fields, byte[] ... params) {
        return null;
    }

    public VectorBuilderFactory.KnnField<String> tvsmindexknnsearchfilterfield(Collection<String> indexs, Long topn, String vector, Collection<String> fields, String pattern, String ... params) {
        return null;
    }

    public VectorBuilderFactory.KnnField<byte[]> tvsmindexknnsearchfilterfield(Collection<byte[]> indexs, Long topn, byte[] vector, Collection<byte[]> fields, byte[] pattern, byte[] ... params) {
        return null;
    }

    public Long tvshincrby(String index, String entityid, String field, long value) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSHINCRBY, (byte[][])new byte[][]{SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid), SafeEncoder.encode((String)field), Protocol.toByteArray((long)value)});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long tvshincrby(byte[] index, byte[] entityid, byte[] field, long value) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSHINCRBY, (byte[][])new byte[][]{index, entityid, field, Protocol.toByteArray((long)value)});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Double tvshincrbyfloat(String index, String entityid, String field, double value) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSHINCRBYFLOAT, (byte[][])new byte[][]{SafeEncoder.encode((String)index), SafeEncoder.encode((String)entityid), SafeEncoder.encode((String)field), Protocol.toByteArray((double)value)});
        return (Double)BuilderFactory.DOUBLE.build(obj);
    }

    public Double tvshincrbyfloat(byte[] index, byte[] entityid, byte[] field, double value) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSHINCRBYFLOAT, (byte[][])new byte[][]{index, entityid, field, Protocol.toByteArray((double)value)});
        return (Double)BuilderFactory.DOUBLE.build(obj);
    }

    public VectorBuilderFactory.Knn<String> tvsgetdistance(String index, String vector, Collection<String> keys, Long topn, Float max_dist, String filter) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)index));
        args.add(SafeEncoder.encode((String)vector));
        args.add(Protocol.toByteArray((int)keys.size()));
        args.addAll(keys.stream().map(key -> SafeEncoder.encode((String)key)).collect(Collectors.toList()));
        if (topn != null) {
            args.add(SafeEncoder.encode((String)"TOPN"));
            args.add(Protocol.toByteArray((long)topn));
        }
        if (max_dist != null) {
            args.add(SafeEncoder.encode((String)"MAX_DIST"));
            args.add(Protocol.toByteArray((double)max_dist.floatValue()));
        }
        if (filter != null) {
            args.add(SafeEncoder.encode((String)"FILTER"));
            args.add(SafeEncoder.encode((String)filter));
        }
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TVSGETDISTANCE, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return (VectorBuilderFactory.Knn)VectorBuilderFactory.STRING_KNN_RESULT.build(obj);
    }

    public VectorBuilderFactory.Knn<byte[]> tvsgetdistance(byte[] index, byte[] vector, Collection<byte[]> keys, Long topn, Float max_dist, byte[] filter) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(index);
        args.add(vector);
        args.add(Protocol.toByteArray((int)keys.size()));
        args.addAll(keys);
        if (topn != null) {
            args.add(SafeEncoder.encode((String)"TOPN"));
            args.add(Protocol.toByteArray((long)topn));
        }
        if (max_dist != null) {
            args.add(SafeEncoder.encode((String)"MAX_DIST"));
            args.add(Protocol.toByteArray((double)max_dist.floatValue()));
        }
        if (filter != null) {
            args.add(SafeEncoder.encode((String)"FILTER"));
            args.add(filter);
        }
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSGETDISTANCE, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return (VectorBuilderFactory.Knn)VectorBuilderFactory.BYTE_KNN_RESULT.build(obj);
    }

    public Boolean tvshexpire(String index, String key, int seconds) {
        return this.tvshexpire(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key), seconds);
    }

    public Boolean tvshexpire(byte[] index, byte[] key, int seconds) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSHEXPIRE, (byte[][])new byte[][]{index, key, Protocol.toByteArray((int)seconds)});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Boolean tvshpexpire(String index, String key, int milliseconds) {
        return this.tvshpexpire(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key), milliseconds);
    }

    public Boolean tvshpexpire(byte[] index, byte[] key, int milliseconds) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSHPEXPIRE, (byte[][])new byte[][]{index, key, Protocol.toByteArray((int)milliseconds)});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Boolean tvshexpireAt(String index, String key, long unixTime) {
        return this.tvshexpireAt(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key), unixTime);
    }

    public Boolean tvshexpireAt(byte[] index, byte[] key, long unixTime) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSHEXPIREAT, (byte[][])new byte[][]{index, key, Protocol.toByteArray((long)unixTime)});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Boolean tvshpexpireAt(String index, String key, long unixTime) {
        return this.tvshpexpireAt(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key), unixTime);
    }

    public Boolean tvshpexpireAt(byte[] index, byte[] key, long unixTime) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSHPEXPIREAT, (byte[][])new byte[][]{index, key, Protocol.toByteArray((long)unixTime)});
        return (Boolean)BuilderFactory.BOOLEAN.build(obj);
    }

    public Long tvshttl(String index, String key) {
        return this.tvshttl(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key));
    }

    public Long tvshttl(byte[] index, byte[] key) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSHTTL, (byte[][])new byte[][]{index, key});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long tvshpttl(String index, String key) {
        return this.tvshpttl(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key));
    }

    public Long tvshpttl(byte[] index, byte[] key) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSHPTTL, (byte[][])new byte[][]{index, key});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long tvshexpiretime(String index, String key) {
        return this.tvshexpiretime(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key));
    }

    public Long tvshexpiretime(byte[] index, byte[] key) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSHEXPIRETIME, (byte[][])new byte[][]{index, key});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long tvshpexpiretime(String index, String key) {
        return this.tvshpexpiretime(SafeEncoder.encode((String)index), SafeEncoder.encode((String)key));
    }

    public Long tvshpexpiretime(byte[] index, byte[] key) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TVSHPEXPIRETIME, (byte[][])new byte[][]{index, key});
        return (Long)BuilderFactory.LONG.build(obj);
    }
}

