/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.sort;

import com.aliyun.tair.tairsearch.search.sort.SortBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.Objects;

public class FieldSortBuilder
extends SortBuilder<FieldSortBuilder> {
    public static final String DOC_FIELD_NAME = "_doc";
    private final String fieldName;

    public FieldSortBuilder(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public JsonObject constructJSON() {
        JsonObject orderObject = new JsonObject();
        orderObject.addProperty("order", this.order.toString().toLowerCase(Locale.ROOT));
        JsonObject sortObject = new JsonObject();
        sortObject.add(this.fieldName, (JsonElement)orderObject);
        return sortObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FieldSortBuilder builder = (FieldSortBuilder)other;
        return Objects.equals(this.fieldName, builder.fieldName) && Objects.equals((Object)this.order, (Object)builder.order);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldName, this.order});
    }
}

