/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.fetch.subphase;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;

public class FetchSourceContext {
    public static final String INCLUDES_FIELD = "includes";
    public static final String EXCLUDES_FIELD = "excludes";
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final FetchSourceContext FETCH_SOURCE = new FetchSourceContext(true);
    public static final FetchSourceContext DO_NOT_FETCH_SOURCE = new FetchSourceContext(false);
    private final boolean fetchSource;
    private final String[] includes;
    private final String[] excludes;

    public FetchSourceContext(boolean fetchSource, String[] includes, String[] excludes) {
        this.fetchSource = fetchSource;
        this.includes = includes == null ? EMPTY_ARRAY : includes;
        this.excludes = excludes == null ? EMPTY_ARRAY : excludes;
    }

    public FetchSourceContext(boolean fetchSource) {
        this(fetchSource, EMPTY_ARRAY, EMPTY_ARRAY);
    }

    public boolean fetchSource() {
        return this.fetchSource;
    }

    public String[] includes() {
        return this.includes;
    }

    public String[] excludes() {
        return this.excludes;
    }

    public JsonObject constructJSON() {
        JsonObject valueObject = new JsonObject();
        JsonArray includeJSON = new JsonArray();
        for (String include : this.includes) {
            includeJSON.add(include);
        }
        JsonArray excludeJSON = new JsonArray();
        for (String exclude : this.excludes) {
            excludeJSON.add(exclude);
        }
        valueObject.add(INCLUDES_FIELD, (JsonElement)includeJSON);
        valueObject.add(EXCLUDES_FIELD, (JsonElement)excludeJSON);
        return valueObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchSourceContext that = (FetchSourceContext)o;
        if (this.fetchSource != that.fetchSource) {
            return false;
        }
        if (!Arrays.equals(this.excludes, that.excludes)) {
            return false;
        }
        return Arrays.equals(this.includes, that.includes);
    }

    public int hashCode() {
        int result = this.fetchSource ? 1 : 0;
        result = 31 * result + (this.includes != null ? Arrays.hashCode(this.includes) : 0);
        result = 31 * result + (this.excludes != null ? Arrays.hashCode(this.excludes) : 0);
        return result;
    }

    public String toString() {
        return this.constructJSON().toString();
    }
}

