/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.builder;

import com.aliyun.tair.tairsearch.search.builder.BaseSearchSourceBuilder;
import com.aliyun.tair.tairsearch.search.builder.KeyCursors;
import com.aliyun.tair.tairsearch.search.sort.SortBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class MSearchSourceBuilder
extends BaseSearchSourceBuilder<MSearchSourceBuilder> {
    public static final String REPLY_FIELD = "reply_with_keys_cursor";
    public static final String CURSORS_FIELD = "keys_cursor";
    private Boolean replyWithKeysCursor = false;
    private KeyCursors keysCursors;

    public static MSearchSourceBuilder searchSource() {
        return new MSearchSourceBuilder();
    }

    public MSearchSourceBuilder replyWithKeysCursor(boolean replyWithKeysCursor) {
        this.replyWithKeysCursor = replyWithKeysCursor;
        return this;
    }

    public boolean replyWithKeysCursor() {
        return this.replyWithKeysCursor;
    }

    public MSearchSourceBuilder keysCursors(KeyCursors keysCursors) {
        this.keysCursors = keysCursors;
        return this;
    }

    public KeyCursors keysCursors() {
        return this.keysCursors;
    }

    @Override
    public JsonObject constructJSON() {
        JsonObject queryObject = new JsonObject();
        if (this.size != -1) {
            queryObject.addProperty("size", (Number)this.size);
        }
        if (this.trackTotalHits) {
            queryObject.addProperty("track_total_hits", Boolean.valueOf(this.trackTotalHits));
        }
        if (this.queryBuilder != null) {
            queryObject.add("query", (JsonElement)this.queryBuilder.constructJSON());
        }
        if (this.fetchSourceContext != null) {
            queryObject.add("_source", (JsonElement)this.fetchSourceContext.constructJSON());
        }
        if (this.sorts != null) {
            JsonArray sortArray = new JsonArray();
            for (SortBuilder sort : this.sorts) {
                sortArray.add((JsonElement)sort.constructJSON());
            }
            queryObject.add("sort", (JsonElement)sortArray);
        }
        if (this.aggregations != null) {
            queryObject.add("aggs", (JsonElement)this.aggregations.constructJSON());
        }
        if (this.replyWithKeysCursor.booleanValue()) {
            queryObject.addProperty(REPLY_FIELD, this.replyWithKeysCursor);
        }
        if (this.keysCursors != null) {
            queryObject.add(CURSORS_FIELD, (JsonElement)this.keysCursors.constructJSON());
        }
        return queryObject;
    }
}

