/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.aggregations.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AggregationPath {
    private static final String AGG_DELIM = ">";
    private final List<PathElement> pathElements;

    public static AggregationPath parse(String path) {
        String[] elements = path.split(AGG_DELIM);
        elements = (String[])Arrays.stream(elements).filter(s -> !"".equals(s)).toArray(String[]::new);
        ArrayList<PathElement> tokens = new ArrayList<PathElement>(elements.length);
        String[] tuple = new String[2];
        for (int i = 0; i < elements.length; ++i) {
            int index;
            String element = elements[i];
            if (i == elements.length - 1) {
                index = element.lastIndexOf(91);
                if (index >= 0) {
                    if (index == 0 || index > element.length() - 3) {
                        throw new IllegalArgumentException("Invalid path element [" + element + "] in path [" + path + "]");
                    }
                    if (element.charAt(element.length() - 1) != ']') {
                        throw new IllegalArgumentException("Invalid path element [" + element + "] in path [" + path + "]");
                    }
                    tokens.add(new PathElement(element, element.substring(0, index), element.substring(index + 1, element.length() - 1)));
                    continue;
                }
                index = element.lastIndexOf(46);
                if (index < 0) {
                    tokens.add(new PathElement(element, element, null));
                    continue;
                }
                if (index == 0 || index > element.length() - 2) {
                    throw new IllegalArgumentException("Invalid path element [" + element + "] in path [" + path + "]");
                }
                tuple = AggregationPath.split(element, index, tuple);
                tokens.add(new PathElement(element, tuple[0], tuple[1]));
                continue;
            }
            index = element.lastIndexOf(91);
            if (index >= 0) {
                if (index == 0 || index > element.length() - 3) {
                    throw new IllegalArgumentException("Invalid path element [" + element + "] in path [" + path + "]");
                }
                if (element.charAt(element.length() - 1) != ']') {
                    throw new IllegalArgumentException("Invalid path element [" + element + "] in path [" + path + "]");
                }
                tokens.add(new PathElement(element, element.substring(0, index), element.substring(index + 1, element.length() - 1)));
                continue;
            }
            tokens.add(new PathElement(element, element, null));
        }
        return new AggregationPath(tokens);
    }

    public AggregationPath(List<PathElement> tokens) {
        this.pathElements = tokens;
        if (tokens == null || tokens.size() == 0) {
            throw new IllegalArgumentException("Invalid path [" + this + "]");
        }
    }

    public PathElement lastPathElement() {
        return this.pathElements.get(this.pathElements.size() - 1);
    }

    public List<PathElement> getPathElements() {
        return this.pathElements;
    }

    public List<String> getPathElementsAsStringList() {
        ArrayList<String> stringPathElements = new ArrayList<String>();
        for (PathElement pathElement : this.pathElements) {
            stringPathElements.add(pathElement.name);
            if (pathElement.key == null) continue;
            stringPathElements.add(pathElement.key);
        }
        return stringPathElements;
    }

    private static String[] split(String toSplit, int index, String[] result) {
        result[0] = toSplit.substring(0, index);
        result[1] = toSplit.substring(index + 1);
        return result;
    }

    public static class PathElement {
        public String fullName;
        public String name;
        public String key;

        public PathElement(String fullName, String name, String key) {
            this.fullName = fullName;
            this.name = name;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathElement token = (PathElement)o;
            if (this.key != null ? !this.key.equals(token.key) : token.key != null) {
                return false;
            }
            return this.name.equals(token.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.fullName;
        }
    }
}

