/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.aggregations.bucket.terms;

import com.aliyun.tair.tairsearch.factory.AggregationRegisterFactory;
import com.aliyun.tair.tairsearch.search.aggregations.Aggregations;
import com.aliyun.tair.tairsearch.search.aggregations.InternalAggregation;
import com.aliyun.tair.tairsearch.search.aggregations.InternalAggregations;
import com.aliyun.tair.tairsearch.search.aggregations.InternalMultiBucketAggregation;
import com.aliyun.tair.tairsearch.search.aggregations.bucket.terms.Terms;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class InternalTerms<A extends InternalTerms<A, B>, B extends AbstractInternalBucket>
extends InternalMultiBucketAggregation<A, B>
implements Terms {
    protected InternalTerms(String name, JsonObject in) {
        super(name, in);
    }

    @Override
    public abstract List<B> getBuckets();

    public abstract B getBucketByKey(String var1);

    public static abstract class Bucket<B extends Bucket<B>>
    extends AbstractInternalBucket {
        protected long docCount;
        protected InternalAggregations aggregations;
        private static String TYPE = "type";
        private JsonObject bucket;

        protected Bucket(JsonObject in) {
            this.bucket = in;
            ArrayList<InternalAggregation> aggregations = new ArrayList<InternalAggregation>();
            for (Map.Entry entry : in.entrySet()) {
                if ("doc_count".equals(entry.getKey())) {
                    this.docCount = ((JsonElement)entry.getValue()).getAsLong();
                    continue;
                }
                if ("key".equals(entry.getKey())) continue;
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                if (!value.isJsonObject()) continue;
                String type = ((JsonObject)value).get(TYPE).getAsString();
                aggregations.add(AggregationRegisterFactory.AggregationRegister.get(type).apply(key, (JsonObject)value));
            }
            this.aggregations = InternalAggregations.from(aggregations);
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Bucket that = (Bucket)obj;
            return Objects.equals(this.docCount, that.docCount) && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.docCount, this.aggregations);
        }

        public String toString() {
            return this.bucket.toString();
        }
    }

    public static abstract class AbstractInternalBucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements Terms.Bucket {
    }
}

