/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.aggregations.bucket;

import com.aliyun.tair.tairsearch.factory.AggregationRegisterFactory;
import com.aliyun.tair.tairsearch.search.aggregations.InternalAggregation;
import com.aliyun.tair.tairsearch.search.aggregations.InternalAggregations;
import com.aliyun.tair.tairsearch.search.aggregations.bucket.SingleBucketAggregation;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class InternalSingleBucketAggregation
extends InternalAggregation
implements SingleBucketAggregation {
    private long docCount;
    private InternalAggregations aggregations;
    private static String TYPE = "type";

    protected InternalSingleBucketAggregation(String name, JsonObject in) {
        super(name, in);
        ArrayList<InternalAggregation> aggregations = new ArrayList<InternalAggregation>();
        for (Map.Entry entry : in.entrySet()) {
            if ("doc_count".equals(entry.getKey())) {
                this.docCount = ((JsonElement)entry.getValue()).getAsLong();
                continue;
            }
            String key = (String)entry.getKey();
            JsonElement value = (JsonElement)entry.getValue();
            if (!value.isJsonObject()) continue;
            String type = ((JsonObject)value).get(TYPE).getAsString();
            aggregations.add(AggregationRegisterFactory.AggregationRegister.get(type).apply(key, (JsonObject)value));
        }
        this.aggregations = InternalAggregations.from(aggregations);
    }

    @Override
    public long getDocCount() {
        return this.docCount;
    }

    @Override
    public InternalAggregations getAggregations() {
        return this.aggregations;
    }

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        String aggName = path.get(0);
        if ("_count".equals(aggName)) {
            if (path.size() > 1) {
                throw new IllegalArgumentException("_count must be the last element in the path");
            }
            return this.getDocCount();
        }
        InternalAggregation aggregation = (InternalAggregation)this.aggregations.get(aggName);
        if (aggregation == null) {
            throw new IllegalArgumentException("Cannot find an aggregation named [" + aggName + "] in [" + this.getName() + "]");
        }
        return aggregation.getProperty(path.subList(1, path.size()));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalSingleBucketAggregation other = (InternalSingleBucketAggregation)obj;
        return Objects.equals(this.docCount, other.docCount) && Objects.equals(this.aggregations, other.aggregations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.docCount, this.aggregations);
    }
}

