/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.aggregations;

import com.aliyun.tair.tairsearch.search.aggregations.Aggregation;
import com.aliyun.tair.tairsearch.search.aggregations.Aggregations;
import com.aliyun.tair.tairsearch.search.aggregations.InternalAggregation;
import com.aliyun.tair.tairsearch.search.aggregations.bucket.MultiBucketsAggregation;
import com.aliyun.tair.tairsearch.search.aggregations.bucket.SingleBucketAggregation;
import com.google.gson.JsonObject;
import java.util.List;

public abstract class InternalMultiBucketAggregation<A extends InternalMultiBucketAggregation, B extends InternalBucket>
extends InternalAggregation
implements MultiBucketsAggregation {
    private static String BUCKEY_COUNT = "_bucket_count";
    private static String COUNT = "_count";
    private static String KEY = "_key";

    public InternalMultiBucketAggregation(String name, JsonObject in) {
        super(name, in);
    }

    public abstract List<B> getBuckets();

    @Override
    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        return InternalMultiBucketAggregation.resolvePropertyFromPath(path, this.getBuckets(), this.getName());
    }

    /*
     * WARNING - void declaration
     */
    static Object resolvePropertyFromPath(List<String> path, List<? extends InternalBucket> buckets, String name) {
        void var5_8;
        String aggName = path.get(0);
        if (BUCKEY_COUNT.equals(aggName)) {
            return buckets.size();
        }
        if (aggName.startsWith("'") && aggName.endsWith("'")) {
            for (InternalBucket internalBucket : buckets) {
                if (!internalBucket.getKeyAsString().equals(aggName.substring(1, aggName.length() - 1))) continue;
                return internalBucket.getProperty(name, path.subList(1, path.size()));
            }
            throw new RuntimeException("Cannot find an key [" + aggName + "] in [" + name + "]");
        }
        Object[] propertyArray = new Object[buckets.size()];
        boolean bl = false;
        while (var5_8 < buckets.size()) {
            propertyArray[var5_8] = buckets.get((int)var5_8).getProperty(name, path);
            ++var5_8;
        }
        return propertyArray;
    }

    public static int countInnerBucket(InternalBucket bucket) {
        int count = 0;
        for (Aggregation agg : bucket.getAggregations().asList()) {
            count += InternalMultiBucketAggregation.countInnerBucket(agg);
        }
        return count;
    }

    public static int countInnerBucket(Aggregation agg) {
        int size;
        block4: {
            block3: {
                size = 0;
                if (!(agg instanceof MultiBucketsAggregation)) break block3;
                MultiBucketsAggregation multi = (MultiBucketsAggregation)agg;
                for (MultiBucketsAggregation.Bucket bucket : multi.getBuckets()) {
                    ++size;
                    for (Aggregation bucketAgg : bucket.getAggregations().asList()) {
                        size += InternalMultiBucketAggregation.countInnerBucket(bucketAgg);
                    }
                }
                break block4;
            }
            if (!(agg instanceof SingleBucketAggregation)) break block4;
            SingleBucketAggregation single = (SingleBucketAggregation)agg;
            for (Aggregation aggregation : single.getAggregations().asList()) {
                size += InternalMultiBucketAggregation.countInnerBucket(aggregation);
            }
        }
        return size;
    }

    public static abstract class InternalBucket
    implements MultiBucketsAggregation.Bucket {
        public Object getProperty(String containingAggName, List<String> path) {
            if (path.isEmpty()) {
                return this;
            }
            Aggregations aggregations = this.getAggregations();
            String aggName = path.get(0);
            if (COUNT.equals(aggName)) {
                if (path.size() > 1) {
                    throw new RuntimeException("_count must be the last element in the path");
                }
                return this.getDocCount();
            }
            if (KEY.equals(aggName)) {
                if (path.size() > 1) {
                    throw new RuntimeException("_key must be the last element in the path");
                }
                return this.getKey();
            }
            InternalAggregation aggregation = (InternalAggregation)aggregations.get(aggName);
            if (aggregation == null) {
                throw new RuntimeException("Cannot find an aggregation named [" + aggName + "] in [" + containingAggName + "]");
            }
            return aggregation.getProperty(path.subList(1, path.size()));
        }
    }
}

