/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.search.aggregations;

import com.aliyun.tair.tairsearch.search.aggregations.AggregationBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

public class AggregatorFactories {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<String> names = new HashSet<String>();
        private final Collection<AggregationBuilder> aggregationBuilders = new LinkedHashSet<AggregationBuilder>();

        public Builder addAggregator(AggregationBuilder factory) {
            if (!this.names.add(factory.getName())) {
                throw new IllegalArgumentException("Two sibling aggregations cannot have the same name: [" + factory.getName() + "]");
            }
            this.aggregationBuilders.add(factory);
            return this;
        }

        public Collection<AggregationBuilder> getAggregatorFactories() {
            return Collections.unmodifiableCollection(this.aggregationBuilders);
        }

        public int count() {
            return this.aggregationBuilders.size();
        }

        public JsonObject constructJSON() {
            JsonObject aggsObject = new JsonObject();
            if (this.aggregationBuilders != null) {
                for (AggregationBuilder subAgg : this.aggregationBuilders) {
                    aggsObject.add(subAgg.getName(), (JsonElement)subAgg.constructJSON());
                }
            }
            return aggsObject;
        }

        public int hashCode() {
            return Objects.hash(this.aggregationBuilders);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Builder other = (Builder)obj;
            return Objects.equals(this.aggregationBuilders, other.aggregationBuilders);
        }

        public String toString() {
            return this.constructJSON().toString();
        }
    }
}

