/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.index.query;

import com.aliyun.tair.tairsearch.index.query.AbstractQueryBuilder;
import com.aliyun.tair.tairsearch.index.query.MultiTermQueryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;

public class RangeQueryBuilder
extends AbstractQueryBuilder<RangeQueryBuilder>
implements MultiTermQueryBuilder {
    public static final String NAME = "range";
    protected final String fieldName;
    private static final String GTE = "gte";
    private static final String GT = "gt";
    private static final String LTE = "lte";
    private static final String LT = "lt";
    private Object from = null;
    private boolean includeLower = true;
    private boolean includeUpper = true;
    private Object to = null;

    public RangeQueryBuilder(String fieldName) {
        if (fieldName == null || fieldName.length() == 0) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        this.fieldName = fieldName;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    public RangeQueryBuilder from(Object from, boolean includeLower) {
        this.from = from;
        this.includeLower = includeLower;
        return this;
    }

    public RangeQueryBuilder from(Object from) {
        return this.from(from, this.includeLower);
    }

    public Object from() {
        return this.from;
    }

    public RangeQueryBuilder gt(Object from) {
        return this.from(from, false);
    }

    public RangeQueryBuilder gte(Object from) {
        return this.from(from, true);
    }

    public RangeQueryBuilder to(Object to, boolean includeUpper) {
        this.to = to;
        this.includeUpper = includeUpper;
        return this;
    }

    public RangeQueryBuilder to(Object to) {
        return this.to(to, this.includeUpper);
    }

    public Object to() {
        return this.to;
    }

    public RangeQueryBuilder lt(Object to) {
        return this.to(to, false);
    }

    public RangeQueryBuilder lte(Object to) {
        return this.to(to, true);
    }

    public RangeQueryBuilder includeLower(boolean includeLower) {
        this.includeLower = includeLower;
        return this;
    }

    public boolean includeLower() {
        return this.includeLower;
    }

    public RangeQueryBuilder includeUpper(boolean includeUpper) {
        this.includeUpper = includeUpper;
        return this;
    }

    public boolean includeUpper() {
        return this.includeUpper;
    }

    @Override
    public JsonObject constructJSON() {
        JsonObject valueObject = new JsonObject();
        Gson gson = new Gson();
        if (this.from != null) {
            if (this.includeLower) {
                valueObject.add(GTE, gson.toJsonTree(this.from));
            } else {
                valueObject.add(GT, gson.toJsonTree(this.from));
            }
        }
        if (this.to != null) {
            if (this.includeUpper) {
                valueObject.add(LTE, gson.toJsonTree(this.to));
            } else {
                valueObject.add(LT, gson.toJsonTree(this.to));
            }
        }
        valueObject.addProperty("boost", (Number)Float.valueOf(this.boost));
        JsonObject queryObject = new JsonObject();
        queryObject.add(this.fieldName, (JsonElement)valueObject);
        JsonObject newQueryObject = new JsonObject();
        newQueryObject.add(NAME, (JsonElement)queryObject);
        return newQueryObject;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.from, this.to, this.includeLower, this.includeUpper);
    }

    @Override
    protected boolean doEquals(RangeQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.from, other.from) && Objects.equals(this.to, other.to) && Objects.equals(this.includeLower, other.includeLower) && Objects.equals(this.includeUpper, other.includeUpper);
    }
}

