/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch.index.query;

import com.aliyun.tair.tairsearch.index.query.AbstractQueryBuilder;
import com.aliyun.tair.tairsearch.index.query.MultiTermQueryBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;

public class PrefixQueryBuilder
extends AbstractQueryBuilder<PrefixQueryBuilder>
implements MultiTermQueryBuilder {
    private static final String VALUE = "value";
    public static final String NAME = "prefix";
    protected final String fieldName;
    protected final String value;

    public PrefixQueryBuilder(String fieldName, String value) {
        if (fieldName == null || fieldName.length() == 0) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.fieldName = fieldName;
        this.value = value;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    public String value() {
        return this.value;
    }

    @Override
    public JsonObject constructJSON() {
        JsonObject valueObject = new JsonObject();
        valueObject.addProperty(VALUE, this.value);
        JsonObject queryObject = new JsonObject();
        queryObject.add(this.fieldName, (JsonElement)valueObject);
        JsonObject newQueryObject = new JsonObject();
        newQueryObject.add(NAME, (JsonElement)queryObject);
        return newQueryObject;
    }

    @Override
    protected final int doHashCode() {
        return Objects.hash(this.fieldName, this.value);
    }

    @Override
    protected boolean doEquals(PrefixQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.value, other.value);
    }
}

