/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairsearch;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.jedis3.ScanResult;
import com.aliyun.tair.tairsearch.action.search.MSearchResponse;
import com.aliyun.tair.tairsearch.action.search.SearchResponse;
import com.aliyun.tair.tairsearch.params.DocInfo;
import com.aliyun.tair.tairsearch.params.DocInfoByte;
import com.aliyun.tair.tairsearch.params.TFTAddDocParams;
import com.aliyun.tair.tairsearch.params.TFTAddSugParams;
import com.aliyun.tair.tairsearch.params.TFTAnalyzerParams;
import com.aliyun.tair.tairsearch.params.TFTDelDocParams;
import com.aliyun.tair.tairsearch.params.TFTExplainScoreParams;
import com.aliyun.tair.tairsearch.params.TFTGetIndexParams;
import com.aliyun.tair.tairsearch.params.TFTGetSugParams;
import com.aliyun.tair.tairsearch.params.TFTMSearchParams;
import com.aliyun.tair.tairsearch.params.TFTMaddDocParams;
import com.aliyun.tair.tairsearch.params.TFTScanParams;
import com.aliyun.tair.tairsearch.search.builder.MSearchSourceBuilder;
import com.aliyun.tair.tairsearch.search.builder.SearchSourceBuilder;
import com.aliyun.tair.util.JoinParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairSearchCluster {
    private final JedisCluster jc;

    public TairSearchCluster(JedisCluster jc) {
        this.jc = jc;
    }

    public String tftmappingindex(String index, String request) {
        return this.tftmappingindex(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request));
    }

    public String tftmappingindex(byte[] index, byte[] request) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTMAPPINGINDEX, (byte[][])new byte[][]{index, request});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftcreateindex(String index, String request) {
        return this.tftcreateindex(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request));
    }

    public String tftcreateindex(byte[] index, byte[] request) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTCREATEINDEX, (byte[][])new byte[][]{index, request});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftupdateindex(String index, String request) {
        return this.tftupdateindex(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request));
    }

    public String tftupdateindex(byte[] index, byte[] request) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTUPDATEINDEX, (byte[][])new byte[][]{index, request});
        return (String)BuilderFactory.STRING.build(obj);
    }

    @Deprecated
    public String tftgetindexmappings(String index) {
        return this.tftgetindexmappings(SafeEncoder.encode((String)index));
    }

    @Deprecated
    public String tftgetindexmappings(byte[] index) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTGETINDEX, (byte[][])new byte[][]{index, SafeEncoder.encode((String)"mappings")});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftgetindex(String index) {
        return this.tftgetindex(SafeEncoder.encode((String)index));
    }

    public String tftgetindex(byte[] index) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTGETINDEX, (byte[][])new byte[][]{index});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftgetindex(String index, TFTGetIndexParams params) {
        return this.tftgetindex(SafeEncoder.encode((String)index), params);
    }

    public String tftgetindex(byte[] index, TFTGetIndexParams params) {
        Object obj = params.getParams() == null ? this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTGETINDEX, (byte[][])new byte[][]{index}) : this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTGETINDEX, (byte[][])new byte[][]{index, params.getParams()});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftadddoc(String index, String request) {
        return this.tftadddoc(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request));
    }

    public String tftadddoc(byte[] index, byte[] request) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTADDDOC, (byte[][])new byte[][]{index, request});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftadddoc(String index, String request, String docId) {
        return this.tftadddoc(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request), SafeEncoder.encode((String)docId));
    }

    public String tftadddoc(byte[] index, byte[] request, byte[] docId) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTADDDOC, (byte[][])new byte[][]{index, request, SafeEncoder.encode((String)"WITH_ID"), docId});
        return (String)BuilderFactory.STRING.build(obj);
    }

    @Deprecated
    public String tftmadddoc(String index, Map<String, String> docs) {
        TFTAddDocParams params = new TFTAddDocParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TFTMADDDOC, params.getByteParams(index, docs));
        return (String)BuilderFactory.STRING.build(obj);
    }

    @Deprecated
    public String tftmadddoc(byte[] index, Map<byte[], byte[]> docs) {
        TFTAddDocParams params = new TFTAddDocParams();
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTMADDDOC, params.getByteParams(index, docs));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftmadddoc(String index, List<DocInfo> docs) {
        TFTMaddDocParams params = new TFTMaddDocParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TFTMADDDOC, params.getByteParams(index, docs));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftmadddoc(byte[] index, List<DocInfoByte> docs) {
        TFTMaddDocParams params = new TFTMaddDocParams();
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTMADDDOC, params.getByteParams(index, docs));
        return (String)BuilderFactory.STRING.build(obj);
    }

    @Deprecated
    public String tftupdatedoc(String index, String docId, String docContent) {
        return this.tftupdatedoc(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId), SafeEncoder.encode((String)docContent));
    }

    @Deprecated
    public String tftupdatedoc(byte[] index, byte[] docId, byte[] docContent) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTUPDATEDOC, (byte[][])new byte[][]{index, docId, docContent});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftupdatedocfield(String index, String docId, String docContent) {
        return this.tftupdatedoc(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId), SafeEncoder.encode((String)docContent));
    }

    public String tftupdatedocfield(byte[] index, byte[] docId, byte[] docContent) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTUPDATEDOCFIELD, (byte[][])new byte[][]{index, docId, docContent});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public Long tftincrlongdocfield(String index, String docId, String field, long value) {
        return this.tftincrlongdocfield(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId), SafeEncoder.encode((String)field), value);
    }

    public Long tftincrlongdocfield(byte[] index, byte[] docId, byte[] field, long value) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTINCRLONGDOCFIELD, (byte[][])new byte[][]{index, docId, field, Protocol.toByteArray((long)value)});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Double tftincrfloatdocfield(String index, String docId, String field, double value) {
        return this.tftincrfloatdocfield(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId), SafeEncoder.encode((String)field), value);
    }

    public Double tftincrfloatdocfield(byte[] index, byte[] docId, byte[] field, double value) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTINCRFLOATDOCFIELD, (byte[][])new byte[][]{index, docId, field, Protocol.toByteArray((double)value)});
        return (Double)BuilderFactory.DOUBLE.build(obj);
    }

    public Long tftdeldocfield(String index, String docId, String ... field) {
        return this.tftdeldocfield(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId), SafeEncoder.encodeMany((String[])field));
    }

    public Long tftdeldocfield(byte[] index, byte[] docId, byte[] ... field) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTDELDOCFIELD, JoinParameters.joinParameters(index, docId, field));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public String tftgetdoc(String index, String docId) {
        return this.tftgetdoc(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId));
    }

    public String tftgetdoc(byte[] index, byte[] docId) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTGETDOC, (byte[][])new byte[][]{index, docId});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftgetdoc(String index, String docId, String request) {
        return this.tftgetdoc(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId), SafeEncoder.encode((String)request));
    }

    public String tftgetdoc(byte[] index, byte[] docId, byte[] request) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTGETDOC, (byte[][])new byte[][]{index, docId, request});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftdeldoc(String index, String ... docId) {
        TFTDelDocParams params = new TFTDelDocParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TFTDELDOC, params.getByteParams(index, docId));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftdeldoc(byte[] index, byte[] ... docId) {
        TFTDelDocParams params = new TFTDelDocParams();
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTDELDOC, params.getByteParams(index, docId));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftdelall(String index) {
        return this.tftdelall(SafeEncoder.encode((String)index));
    }

    public String tftdelall(byte[] index) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTDELALL, (byte[][])new byte[][]{index});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public SearchResponse tftsearch(String index, SearchSourceBuilder ssb) {
        return new SearchResponse(this.tftsearch(SafeEncoder.encode((String)index), SafeEncoder.encode((String)ssb.toString())));
    }

    public SearchResponse tftsearch(byte[] index, SearchSourceBuilder ssb) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTSEARCH, (byte[][])new byte[][]{index, SafeEncoder.encode((String)ssb.toString())});
        return new SearchResponse((String)BuilderFactory.STRING.build(obj));
    }

    public SearchResponse tftsearch(String index, SearchSourceBuilder ssb, boolean use_cache) {
        return new SearchResponse(this.tftsearch(SafeEncoder.encode((String)index), SafeEncoder.encode((String)ssb.toString())));
    }

    public SearchResponse tftsearch(byte[] index, SearchSourceBuilder ssb, boolean use_cache) {
        Object obj = use_cache ? this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTSEARCH, (byte[][])new byte[][]{index, SafeEncoder.encode((String)ssb.toString()), SafeEncoder.encode((String)"use_cache")}) : this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTSEARCH, (byte[][])new byte[][]{index, SafeEncoder.encode((String)ssb.toString())});
        return new SearchResponse((String)BuilderFactory.STRING.build(obj));
    }

    public String tftsearch(String index, String request) {
        return this.tftsearch(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request));
    }

    public String tftsearch(byte[] index, byte[] request) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTSEARCH, (byte[][])new byte[][]{index, request});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftsearch(String index, String request, boolean use_cache) {
        return this.tftsearch(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request), use_cache);
    }

    public String tftsearch(byte[] index, byte[] request, boolean use_cache) {
        Object obj = use_cache ? this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTSEARCH, (byte[][])new byte[][]{index, request, SafeEncoder.encode((String)"use_cache")}) : this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTSEARCH, (byte[][])new byte[][]{index, request});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftmsearch(String request, String ... indexes) {
        TFTMSearchParams params = new TFTMSearchParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)indexes[0]), (ProtocolCommand)ModuleCommand.TFTMSEARCH, params.getByteParams(request, indexes));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftmsearch(byte[] request, byte[] ... indexes) {
        TFTMSearchParams params = new TFTMSearchParams();
        Object obj = this.jc.sendCommand(indexes[0], (ProtocolCommand)ModuleCommand.TFTMSEARCH, params.getByteParams(request, indexes));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public MSearchResponse tftmsearch(MSearchSourceBuilder ssb, String ... indexes) {
        TFTMSearchParams params = new TFTMSearchParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)indexes[0]), (ProtocolCommand)ModuleCommand.TFTMSEARCH, params.getByteParams(ssb.toString(), indexes));
        return new MSearchResponse((String)BuilderFactory.STRING.build(obj));
    }

    public MSearchResponse tftmsearch(MSearchSourceBuilder ssb, byte[] ... indexes) {
        TFTMSearchParams params = new TFTMSearchParams();
        Object obj = this.jc.sendCommand(indexes[0], (ProtocolCommand)ModuleCommand.TFTMSEARCH, params.getByteParams(SafeEncoder.encode((String)ssb.toString()), indexes));
        return new MSearchResponse((String)BuilderFactory.STRING.build(obj));
    }

    public Long tftexists(String index, String docId) {
        return this.tftexists(SafeEncoder.encode((String)index), SafeEncoder.encode((String)docId));
    }

    public Long tftexists(byte[] index, byte[] docId) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTEXISTS, (byte[][])new byte[][]{index, docId});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long tftdocnum(String index) {
        return this.tftdocnum(SafeEncoder.encode((String)index));
    }

    public Long tftdocnum(byte[] index) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTDOCNUM, (byte[][])new byte[][]{index});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public ScanResult<String> tftscandocid(String index, String cursor) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTSCANDOCID, new String[]{index, cursor});
        List result = (List)obj;
        String newcursor = new String((byte[])result.get(0));
        ArrayList<String> results = new ArrayList<String>();
        List rawResults = (List)result.get(1);
        for (byte[] bs : rawResults) {
            results.add(SafeEncoder.encode((byte[])bs));
        }
        return new ScanResult<String>(newcursor, results);
    }

    public ScanResult<byte[]> tftscandocid(byte[] index, byte[] cursor) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTSCANDOCID, (byte[][])new byte[][]{index, cursor});
        List result = (List)obj;
        byte[] newcursor = (byte[])result.get(0);
        List rawResults = (List)result.get(1);
        return new ScanResult<byte[]>(newcursor, rawResults);
    }

    public ScanResult<String> tftscandocid(String index, String cursor, TFTScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)index));
        args.add(SafeEncoder.encode((String)cursor));
        args.addAll(params.getParams());
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TFTSCANDOCID, (byte[][])args.toArray((T[])new byte[args.size()][]));
        List result = (List)obj;
        String newcursor = new String((byte[])result.get(0));
        ArrayList<String> results = new ArrayList<String>();
        List rawResults = (List)result.get(1);
        for (byte[] bs : rawResults) {
            results.add(SafeEncoder.encode((byte[])bs));
        }
        return new ScanResult<String>(newcursor, results);
    }

    public ScanResult<byte[]> tftscandocid(byte[] index, byte[] cursor, TFTScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(index);
        args.add(cursor);
        args.addAll(params.getParams());
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTSCANDOCID, (byte[][])args.toArray((T[])new byte[args.size()][]));
        List result = (List)obj;
        byte[] newcursor = (byte[])result.get(0);
        List rawResults = (List)result.get(1);
        return new ScanResult<byte[]>(newcursor, rawResults);
    }

    public String tftanalyzer(String analyzerName, String text) {
        return this.tftanalyzer(SafeEncoder.encode((String)analyzerName), SafeEncoder.encode((String)text));
    }

    public String tftanalyzer(byte[] analyzerName, byte[] text) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)UUID.randomUUID().toString()), (ProtocolCommand)ModuleCommand.TFTANALYZER, (byte[][])new byte[][]{analyzerName, text});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftanalyzer(String analyzerName, String text, TFTAnalyzerParams params) {
        return this.tftanalyzer(SafeEncoder.encode((String)analyzerName), SafeEncoder.encode((String)text), params);
    }

    public String tftanalyzer(byte[] analyzerName, byte[] text, TFTAnalyzerParams params) {
        byte[] key = params.getByteParam("index");
        if (key == null) {
            key = SafeEncoder.encode((String)UUID.randomUUID().toString());
        }
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.TFTANALYZER, params.getByteParams(analyzerName, text));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftexplaincost(String index, SearchSourceBuilder ssb) {
        return this.tftexplaincost(SafeEncoder.encode((String)index), SafeEncoder.encode((String)ssb.toString()));
    }

    public String tftexplaincost(byte[] index, SearchSourceBuilder ssb) {
        return this.tftexplaincost(index, SafeEncoder.encode((String)ssb.toString()));
    }

    public String tftexplaincost(String index, String request) {
        return this.tftexplaincost(SafeEncoder.encode((String)index), SafeEncoder.encode((String)request));
    }

    public String tftexplaincost(byte[] index, byte[] request) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTEXPLAINCOST, (byte[][])new byte[][]{index, request});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftexplainscore(String index, SearchSourceBuilder ssb, String ... docId) {
        return this.tftexplainscore(index, ssb.toString(), docId);
    }

    public String tftexplainscore(byte[] index, SearchSourceBuilder ssb, byte[] ... docId) {
        return this.tftexplainscore(index, SafeEncoder.encode((String)ssb.toString()), docId);
    }

    public String tftexplainscore(String index, String request, String ... docId) {
        TFTExplainScoreParams params = new TFTExplainScoreParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TFTEXPLAINSCORE, params.getByteParams(index, request, docId));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public String tftexplainscore(byte[] index, byte[] request, byte[] ... docId) {
        TFTExplainScoreParams params = new TFTExplainScoreParams();
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTEXPLAINSCORE, params.getByteParams(index, request, docId));
        return (String)BuilderFactory.STRING.build(obj);
    }

    public Long tftaddsug(String index, Map<String, Integer> texts) {
        TFTAddSugParams params = new TFTAddSugParams();
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TFTADDSUG, params.getByteParams(index, texts));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long tftaddsug(byte[] index, Map<byte[], Integer> texts) {
        TFTAddSugParams params = new TFTAddSugParams();
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTADDSUG, params.getByteParams(index, texts));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long tftdelsug(String index, String ... text) {
        return this.tftdelsug(SafeEncoder.encode((String)index), SafeEncoder.encodeMany((String[])text));
    }

    public Long tftdelsug(byte[] index, byte[] ... text) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTDELSUG, JoinParameters.joinParameters(index, text));
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long tftsugnum(String index) {
        return this.tftsugnum(SafeEncoder.encode((String)index));
    }

    public Long tftsugnum(byte[] index) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTSUGNUM, (byte[][])new byte[][]{index});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public List<String> tftgetsug(String index, String prefix) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTGETSUG, new String[]{index, prefix});
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> tftgetsug(byte[] index, byte[] prefix) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTGETSUG, (byte[][])new byte[][]{index, prefix});
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public List<String> tftgetsug(String index, String prefix, TFTGetSugParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(SafeEncoder.encode((String)index));
        args.add(SafeEncoder.encode((String)prefix));
        args.addAll(params.getParams());
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TFTGETSUG, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> tftgetsug(byte[] index, byte[] prefix, TFTGetSugParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(index);
        args.add(prefix);
        args.addAll(params.getParams());
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTGETSUG, (byte[][])args.toArray((T[])new byte[args.size()][]));
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }

    public List<String> tftgetallsugs(String index) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)index), (ProtocolCommand)ModuleCommand.TFTGETALLSUGS, (byte[][])new byte[][]{SafeEncoder.encode((String)index)});
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public List<byte[]> tftgetallsugs(byte[] index) {
        Object obj = this.jc.sendCommand(index, (ProtocolCommand)ModuleCommand.TFTGETALLSUGS, (byte[][])new byte[][]{index});
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }
}

