/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairgis;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.tairgis.factory.GisBuilderFactory;
import com.aliyun.tair.tairgis.params.GisParams;
import com.aliyun.tair.tairgis.params.GisSearchResponse;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.args.GeoUnit;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairGisPipeline
extends Pipeline {
    public TairGisPipeline(Jedis jedis) {
        super(jedis);
    }

    public Response<Long> gisadd(String key, String polygonName, String polygonWktText) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISADD).key((Object)key).add(polygonName).add(polygonWktText), BuilderFactory.LONG));
    }

    public Response<Long> gisadd(byte[] key, byte[] polygonName, byte[] polygonWktText) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISADD).key((Object)key).add(polygonName).add(polygonWktText), BuilderFactory.LONG));
    }

    public Response<String> gisget(String key, String polygonName) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISGET).key((Object)key).add(polygonName), BuilderFactory.STRING));
    }

    public Response<byte[]> gisget(byte[] key, byte[] polygonName) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISGET).key((Object)key).add(polygonName), Jedis3BuilderFactory.BYTE_ARRAY));
    }

    public Response<Map<String, String>> gissearch(String key, String pointWktText) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISSEARCH).key((Object)key).add(pointWktText), GisBuilderFactory.GISSEARCH_RESULT_MAP_STRING));
    }

    public Response<Map<byte[], byte[]>> gissearch(byte[] key, byte[] pointWktText) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISSEARCH).key((Object)key).add(pointWktText), GisBuilderFactory.GISSEARCH_RESULT_MAP_BYTE));
    }

    public Response<List<GisSearchResponse>> gissearch(String key, double longitude, double latitude, double radius, GeoUnit unit, GisParams gisParams) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISSEARCH).addObjects((Object[])gisParams.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)"radius"), Protocol.toByteArray((double)longitude), Protocol.toByteArray((double)latitude), Protocol.toByteArray((double)radius), unit.getRaw())), GisBuilderFactory.GISSEARCH_WITH_PARAMS_RESULT));
    }

    public Response<List<GisSearchResponse>> gissearch(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GisParams gisParams) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISSEARCH).addObjects((Object[])gisParams.getByteParams(key, SafeEncoder.encode((String)"radius"), Protocol.toByteArray((double)longitude), Protocol.toByteArray((double)latitude), Protocol.toByteArray((double)radius), unit.getRaw())), GisBuilderFactory.GISSEARCH_WITH_PARAMS_RESULT));
    }

    public Response<List<GisSearchResponse>> gissearchByMember(String key, String member, double radius, GeoUnit unit, GisParams gisParams) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISSEARCH).addObjects((Object[])gisParams.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)"member"), SafeEncoder.encode((String)member), Protocol.toByteArray((double)radius), unit.getRaw())), GisBuilderFactory.GISSEARCH_WITH_PARAMS_RESULT));
    }

    public Response<List<GisSearchResponse>> gissearchByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GisParams gisParams) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISSEARCH).addObjects((Object[])gisParams.getByteParams(key, SafeEncoder.encode((String)"member"), member, Protocol.toByteArray((double)radius), unit.getRaw())), GisBuilderFactory.GISSEARCH_WITH_PARAMS_RESULT));
    }

    public Response<Map<String, String>> giscontains(String key, String pointWktText) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISCONTAINS).key((Object)key).add(pointWktText), GisBuilderFactory.GISSEARCH_RESULT_MAP_STRING));
    }

    public Response<List<String>> giscontains(String key, String pointWktText, GisParams gisParams) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISCONTAINS).addObjects((Object[])gisParams.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)pointWktText))), GisBuilderFactory.GISSEARCH_RESULT_LIST_STRING));
    }

    public Response<Map<byte[], byte[]>> giscontains(byte[] key, byte[] pointWktText) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISCONTAINS).key((Object)key).add(pointWktText), GisBuilderFactory.GISSEARCH_RESULT_MAP_BYTE));
    }

    public Response<List<byte[]>> giscontains(byte[] key, byte[] pointWktText, GisParams gisParams) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISCONTAINS).addObjects((Object[])gisParams.getByteParams(key, pointWktText)), GisBuilderFactory.GISSEARCH_RESULT_BYTE_ARRAY_LIST));
    }

    public Response<Map<String, String>> giswithin(String key, String pointWktText) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISWITHIN).key((Object)key).add(pointWktText), GisBuilderFactory.GISSEARCH_RESULT_MAP_STRING));
    }

    public Response<List<String>> giswithin(String key, String pointWktText, GisParams gisParams) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISWITHIN).addObjects((Object[])gisParams.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)pointWktText))), GisBuilderFactory.GISSEARCH_RESULT_LIST_STRING));
    }

    public Response<Map<byte[], byte[]>> giswithin(byte[] key, byte[] pointWktText) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISWITHIN).key((Object)key).add(pointWktText), GisBuilderFactory.GISSEARCH_RESULT_MAP_BYTE));
    }

    public Response<List<byte[]>> giswithin(byte[] key, byte[] pointWktText, GisParams gisParams) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISWITHIN).addObjects((Object[])gisParams.getByteParams(key, pointWktText)), GisBuilderFactory.GISSEARCH_RESULT_BYTE_ARRAY_LIST));
    }

    public Response<Map<String, String>> gisintersects(String key, String pointWktText) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISINTERSECTS).key((Object)key).add(pointWktText), GisBuilderFactory.GISSEARCH_RESULT_MAP_STRING));
    }

    public Response<Map<byte[], byte[]>> gisintersects(byte[] key, byte[] pointWktText) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISINTERSECTS).key((Object)key).add(pointWktText), GisBuilderFactory.GISSEARCH_RESULT_MAP_BYTE));
    }

    public Response<String> gisdel(String key, String polygonName) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISDEL).key((Object)key).add(polygonName), BuilderFactory.STRING));
    }

    public Response<byte[]> gisdel(byte[] key, byte[] polygonName) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISDEL).key((Object)key).add(polygonName), Jedis3BuilderFactory.BYTE_ARRAY));
    }

    public Response<Map<String, String>> gisgetall(String key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISGETALL).key((Object)key), BuilderFactory.STRING_MAP));
    }

    public Response<List<String>> gisgetall(String key, GisParams gisParams) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISGETALL).addObjects((Object[])gisParams.getByteParams(new byte[][]{SafeEncoder.encode((String)key)})), BuilderFactory.STRING_LIST));
    }

    public Response<Map<byte[], byte[]>> gisgetall(byte[] key) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISGETALL).key((Object)key), Jedis3BuilderFactory.BYTE_ARRAY_MAP));
    }

    public Response<List<byte[]>> gisgetall(byte[] key, GisParams gisParams) {
        return this.appendCommand(new CommandObject(new CommandArguments((ProtocolCommand)ModuleCommand.GISGETALL).addObjects((Object[])gisParams.getByteParams(new byte[][]{key})), Jedis3BuilderFactory.BYTE_ARRAY_LIST));
    }
}

