/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.tairgis;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.Jedis3BuilderFactory;
import com.aliyun.tair.tairgis.factory.GisBuilderFactory;
import com.aliyun.tair.tairgis.params.GisParams;
import com.aliyun.tair.tairgis.params.GisSearchResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.args.GeoUnit;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class TairGisCluster {
    private JedisCluster jc;

    public TairGisCluster(JedisCluster jc) {
        this.jc = jc;
    }

    public Long gisadd(String key, String polygonName, String polygonWktText) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISADD, new String[]{key, polygonName, polygonWktText});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public Long gisadd(byte[] key, byte[] polygonName, byte[] polygonWktText) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISADD, (byte[][])new byte[][]{key, polygonName, polygonWktText});
        return (Long)BuilderFactory.LONG.build(obj);
    }

    public String gisget(String key, String polygonName) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISGET, new String[]{key, polygonName});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public byte[] gisget(byte[] key, byte[] polygonName) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISGET, (byte[][])new byte[][]{key, polygonName});
        return (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
    }

    public Map<String, String> gissearch(String key, String pointWktText) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISSEARCH, new String[]{key, pointWktText});
        List result = (List)obj;
        if (null == result || 0 == result.size()) {
            return new HashMap<String, String>();
        }
        List rawResults = (List)result.get(1);
        return (Map)BuilderFactory.STRING_MAP.build((Object)rawResults);
    }

    public Map<byte[], byte[]> gissearch(byte[] key, byte[] pointWktText) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISSEARCH, (byte[][])new byte[][]{key, pointWktText});
        List result = (List)obj;
        if (null == result || 0 == result.size()) {
            return new HashMap<byte[], byte[]>();
        }
        List rawResults = (List)result.get(1);
        return (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build((Object)rawResults);
    }

    public List<GisSearchResponse> gissearch(String key, double longitude, double latitude, double radius, GeoUnit unit, GisParams gisParams) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.GISSEARCH, gisParams.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)"radius"), Protocol.toByteArray((double)longitude), Protocol.toByteArray((double)latitude), Protocol.toByteArray((double)radius), unit.getRaw()));
        return (List)GisBuilderFactory.GISSEARCH_WITH_PARAMS_RESULT.build(obj);
    }

    public List<GisSearchResponse> gissearch(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GisParams gisParams) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISSEARCH, gisParams.getByteParams(key, SafeEncoder.encode((String)"radius"), Protocol.toByteArray((double)longitude), Protocol.toByteArray((double)latitude), Protocol.toByteArray((double)radius), unit.getRaw()));
        return (List)GisBuilderFactory.GISSEARCH_WITH_PARAMS_RESULT.build(obj);
    }

    public List<GisSearchResponse> gissearchByMember(String key, String member, double radius, GeoUnit unit, GisParams gisParams) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.GISSEARCH, gisParams.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)"member"), SafeEncoder.encode((String)member), Protocol.toByteArray((double)radius), unit.getRaw()));
        return (List)GisBuilderFactory.GISSEARCH_WITH_PARAMS_RESULT.build(obj);
    }

    public List<GisSearchResponse> gissearchByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GisParams gisParams) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISSEARCH, gisParams.getByteParams(key, SafeEncoder.encode((String)"member"), member, Protocol.toByteArray((double)radius), unit.getRaw()));
        return (List)GisBuilderFactory.GISSEARCH_WITH_PARAMS_RESULT.build(obj);
    }

    public Map<String, String> giscontains(String key, String pointWktText) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISCONTAINS, new String[]{key, pointWktText});
        List result = (List)obj;
        if (null == result || 0 == result.size()) {
            return new HashMap<String, String>();
        }
        List rawResults = (List)result.get(1);
        return (Map)BuilderFactory.STRING_MAP.build((Object)rawResults);
    }

    public List<String> giscontains(String key, String pointWktText, GisParams gisParams) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.GISCONTAINS, gisParams.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)pointWktText)));
        List result = (List)obj;
        if (null == result || 0 == result.size()) {
            return new ArrayList<String>();
        }
        List rawResults = (List)result.get(1);
        return (List)BuilderFactory.STRING_LIST.build((Object)rawResults);
    }

    public Map<byte[], byte[]> giscontains(byte[] key, byte[] pointWktText) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISCONTAINS, (byte[][])new byte[][]{key, pointWktText});
        List result = (List)obj;
        if (null == result || 0 == result.size()) {
            return new HashMap<byte[], byte[]>();
        }
        List rawResults = (List)result.get(1);
        return (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build((Object)rawResults);
    }

    public List<byte[]> giscontains(byte[] key, byte[] pointWktText, GisParams gisParams) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISCONTAINS, gisParams.getByteParams(key, pointWktText));
        List result = (List)obj;
        if (null == result || 0 == result.size()) {
            return new ArrayList<byte[]>();
        }
        List rawResults = (List)result.get(1);
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build((Object)rawResults);
    }

    public Map<String, String> giswithin(String key, String pointWktText) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISWITHIN, new String[]{key, pointWktText});
        List result = (List)obj;
        if (null == result || 0 == result.size()) {
            return new HashMap<String, String>();
        }
        List rawResults = (List)result.get(1);
        return (Map)BuilderFactory.STRING_MAP.build((Object)rawResults);
    }

    public List<String> giswithin(String key, String pointWktText, GisParams gisParams) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.GISWITHIN, gisParams.getByteParams(SafeEncoder.encode((String)key), SafeEncoder.encode((String)pointWktText)));
        List result = (List)obj;
        if (null == result || 0 == result.size()) {
            return new ArrayList<String>();
        }
        List rawResults = (List)result.get(1);
        return (List)BuilderFactory.STRING_LIST.build((Object)rawResults);
    }

    public Map<byte[], byte[]> giswithin(byte[] key, byte[] pointWktText) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISWITHIN, (byte[][])new byte[][]{key, pointWktText});
        List result = (List)obj;
        if (null == result || 0 == result.size()) {
            return new HashMap<byte[], byte[]>();
        }
        List rawResults = (List)result.get(1);
        return (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build((Object)rawResults);
    }

    public List<byte[]> giswithin(byte[] key, byte[] pointWktText, GisParams gisParams) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISWITHIN, gisParams.getByteParams(key, pointWktText));
        List result = (List)obj;
        if (null == result || 0 == result.size()) {
            return new ArrayList<byte[]>();
        }
        List rawResults = (List)result.get(1);
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build((Object)rawResults);
    }

    public Map<String, String> gisintersects(String key, String pointWktText) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISINTERSECTS, new String[]{key, pointWktText});
        List result = (List)obj;
        if (null == result || 0 == result.size()) {
            return new HashMap<String, String>();
        }
        List rawResults = (List)result.get(1);
        return (Map)BuilderFactory.STRING_MAP.build((Object)rawResults);
    }

    public Map<byte[], byte[]> gisintersects(byte[] key, byte[] pointWktText) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISINTERSECTS, (byte[][])new byte[][]{key, pointWktText});
        List result = (List)obj;
        if (null == result || 0 == result.size()) {
            return new HashMap<byte[], byte[]>();
        }
        List rawResults = (List)result.get(1);
        return (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build((Object)rawResults);
    }

    public String gisdel(String key, String polygonName) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISDEL, new String[]{key, polygonName});
        return (String)BuilderFactory.STRING.build(obj);
    }

    public byte[] gisdel(byte[] key, byte[] polygonName) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISDEL, (byte[][])new byte[][]{key, polygonName});
        return (byte[])Jedis3BuilderFactory.BYTE_ARRAY.build(obj);
    }

    public Map<String, String> gisgetall(String key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISGETALL, new String[]{key});
        return (Map)BuilderFactory.STRING_MAP.build(obj);
    }

    public List<String> gisgetall(String key, GisParams gisParams) {
        Object obj = this.jc.sendCommand(SafeEncoder.encode((String)key), (ProtocolCommand)ModuleCommand.GISGETALL, gisParams.getByteParams(new byte[][]{SafeEncoder.encode((String)key)}));
        return (List)BuilderFactory.STRING_LIST.build(obj);
    }

    public Map<byte[], byte[]> gisgetall(byte[] key) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISGETALL, (byte[][])new byte[][]{key});
        return (Map)Jedis3BuilderFactory.BYTE_ARRAY_MAP.build(obj);
    }

    public List<byte[]> gisgetall(byte[] key, GisParams gisParams) {
        Object obj = this.jc.sendCommand(key, (ProtocolCommand)ModuleCommand.GISGETALL, gisParams.getByteParams(new byte[][]{key}));
        return (List)Jedis3BuilderFactory.BYTE_ARRAY_LIST.build(obj);
    }
}

