/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.mcommamd;

import com.aliyun.tair.ModuleCommand;
import com.aliyun.tair.jedis3.ScanParams;
import com.aliyun.tair.jedis3.ScanResult;
import com.aliyun.tair.mcommamd.factory.AliyunRedisCommandBuilderFactory;
import com.aliyun.tair.mcommamd.results.SlotAndNodeIndex;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisMonitor;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.util.SafeEncoder;

public class AliyunRedisCommand {
    private Jedis jedis;
    private JedisPool jedisPool;

    public AliyunRedisCommand(Jedis jedis) {
        this.jedis = jedis;
    }

    public AliyunRedisCommand(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    private Jedis getJedis() {
        if (this.jedisPool != null) {
            return this.jedisPool.getResource();
        }
        return this.jedis;
    }

    private void releaseJedis(Jedis jedis) {
        if (this.jedisPool != null) {
            jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlotAndNodeIndex infoKey(String key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)Protocol.Command.INFO, new String[]{"KEY", key});
            SlotAndNodeIndex slotAndNodeIndex = (SlotAndNodeIndex)AliyunRedisCommandBuilderFactory.SlotAndNodeIndexResult.build(obj);
            return slotAndNodeIndex;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlotAndNodeIndex infoKey(byte[] key) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)Protocol.Command.INFO, (byte[][])new byte[][]{"KEY".getBytes(), key});
            SlotAndNodeIndex slotAndNodeIndex = (SlotAndNodeIndex)AliyunRedisCommandBuilderFactory.SlotAndNodeIndexResult.build(obj);
            return slotAndNodeIndex;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String iInfo(int index) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.IINFO, new String[]{String.valueOf(index)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String iInfo(int index, String section) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.IINFO, new String[]{String.valueOf(index), section});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rIInfo(int index, int roIndex) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.RIINFO, new String[]{String.valueOf(index), String.valueOf(roIndex)});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rIInfo(int index, int roIndex, String section) {
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.RIINFO, new String[]{String.valueOf(index), String.valueOf(roIndex), section});
            String string = (String)BuilderFactory.STRING.build(obj);
            return string;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public ScanResult<String> iScan(int index, String cursor) {
        return this.iScan(index, cursor, new ScanParams());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<String> iScan(int index, String cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(String.valueOf(index).getBytes());
        args.add(cursor.getBytes());
        args.addAll(params.getParams());
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.ISCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
            List result = (List)BuilderFactory.RAW_OBJECT_LIST.build(obj);
            String newcursor = new String((byte[])result.get(0));
            ArrayList<String> results = new ArrayList<String>();
            List rawResults = (List)result.get(1);
            for (byte[] bs : rawResults) {
                results.add(SafeEncoder.encode((byte[])bs));
            }
            ScanResult scanResult = new ScanResult(newcursor, results);
            return scanResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public ScanResult<byte[]> iScan(int index, byte[] cursor) {
        return this.iScan(index, cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScanResult<byte[]> iScan(int index, byte[] cursor, ScanParams params) {
        ArrayList<byte[]> args = new ArrayList<byte[]>();
        args.add(String.valueOf(index).getBytes());
        args.add(cursor);
        args.addAll(params.getParams());
        Jedis jedis = this.getJedis();
        try {
            Object obj = jedis.sendCommand((ProtocolCommand)ModuleCommand.ISCAN, (byte[][])args.toArray((T[])new byte[args.size()][]));
            List result = (List)BuilderFactory.RAW_OBJECT_LIST.build(obj);
            byte[] newcursor = (byte[])result.get(0);
            List rawResults = (List)result.get(1);
            ScanResult<byte[]> scanResult = new ScanResult<byte[]>(newcursor, rawResults);
            return scanResult;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public void iMonitor(int index, JedisMonitor jedisMonitor) {
        Jedis jedis = this.getJedis();
        try {
            jedis.sendCommand((ProtocolCommand)ModuleCommand.IMONITOR, new String[]{String.valueOf(index)});
            jedisMonitor.proceed(this.getJedis().getClient());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }

    public void rIMonitor(int index, int roIndex, JedisMonitor jedisMonitor) {
        Jedis jedis = this.getJedis();
        try {
            jedis.sendCommand((ProtocolCommand)ModuleCommand.RIMONITOR, new String[]{String.valueOf(index), String.valueOf(roIndex)});
            jedisMonitor.proceed(this.getJedis().getClient());
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.releaseJedis(jedis);
        }
    }
}

