/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.jedis3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.util.SafeEncoder;

public abstract class Params {
    private Map<String, Object> params;

    public <T> T getParam(String name) {
        if (this.params == null) {
            return null;
        }
        return (T)this.params.get(name);
    }

    public byte[][] getByteParams() {
        if (this.params == null) {
            return new byte[0][];
        }
        ArrayList<byte[]> byteParams = new ArrayList<byte[]>();
        for (Map.Entry<String, Object> param : this.params.entrySet()) {
            byteParams.add(SafeEncoder.encode((String)param.getKey()));
            Object value = param.getValue();
            if (value == null) continue;
            if (value instanceof byte[]) {
                byteParams.add((byte[])value);
                continue;
            }
            if (value instanceof Boolean) {
                byteParams.add(Protocol.toByteArray((boolean)((Boolean)value)));
                continue;
            }
            if (value instanceof Integer) {
                byteParams.add(Protocol.toByteArray((int)((Integer)value)));
                continue;
            }
            if (value instanceof Long) {
                byteParams.add(Protocol.toByteArray((long)((Long)value)));
                continue;
            }
            if (value instanceof Double) {
                byteParams.add(Protocol.toByteArray((double)((Double)value)));
                continue;
            }
            byteParams.add(SafeEncoder.encode((String)String.valueOf(value)));
        }
        return (byte[][])byteParams.toArray((T[])new byte[byteParams.size()][]);
    }

    protected boolean contains(String name) {
        if (this.params == null) {
            return false;
        }
        return this.params.containsKey(name);
    }

    protected void addParam(String name, Object value) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(name, value);
    }

    protected void addParam(String name) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(name, null);
    }

    public String toString() {
        ArrayList<Object> paramsFlatList = new ArrayList<Object>();
        if (this.params != null) {
            for (Map.Entry<String, Object> param : this.params.entrySet()) {
                paramsFlatList.add(param.getKey());
                Object value = param.getValue();
                if (value == null) continue;
                paramsFlatList.add(SafeEncoder.encodeObject((Object)value));
            }
        }
        return paramsFlatList.toString();
    }
}

