/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.tair.jedis3;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Builder;
import redis.clients.jedis.util.JedisByteHashMap;
import redis.clients.jedis.util.SafeEncoder;

public final class Jedis3BuilderFactory {
    public static final Builder<byte[]> BYTE_ARRAY = new Builder<byte[]>(){

        public byte[] build(Object data) {
            return (byte[])data;
        }

        public String toString() {
            return "byte[]";
        }
    };
    public static final Builder<List<byte[]>> BYTE_ARRAY_LIST = new Builder<List<byte[]>>(){

        public List<byte[]> build(Object data) {
            if (null == data) {
                return null;
            }
            return (List)data;
        }

        public String toString() {
            return "List<byte[]>";
        }
    };
    public static final Builder<Map<byte[], byte[]>> BYTE_ARRAY_MAP = new Builder<Map<byte[], byte[]>>(){

        public Map<byte[], byte[]> build(Object data) {
            List flatHash = (List)data;
            JedisByteHashMap hash = new JedisByteHashMap();
            Iterator iterator = flatHash.iterator();
            while (iterator.hasNext()) {
                hash.put(iterator.next(), iterator.next());
            }
            return hash;
        }

        public String toString() {
            return "Map<byte[], byte[]>";
        }
    };
    public static final Builder<Set<String>> STRING_ZSET = new Builder<Set<String>>(){

        public Set<String> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            LinkedHashSet<String> result = new LinkedHashSet<String>(l.size(), 1.0f);
            for (byte[] barray : l) {
                if (barray == null) {
                    result.add(null);
                    continue;
                }
                result.add(SafeEncoder.encode((byte[])barray));
            }
            return result;
        }

        public String toString() {
            return "ZSet<String>";
        }
    };
    public static final Builder<Set<byte[]>> BYTE_ARRAY_ZSET = new Builder<Set<byte[]>>(){

        public Set<byte[]> build(Object data) {
            if (null == data) {
                return null;
            }
            List l = (List)data;
            LinkedHashSet<byte[]> result = new LinkedHashSet<byte[]>(l);
            for (byte[] barray : l) {
                if (barray == null) {
                    result.add(null);
                    continue;
                }
                result.add(barray);
            }
            return result;
        }

        public String toString() {
            return "ZSet<byte[]>";
        }
    };
}

