/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.type;

import com.aliyun.odps.OdpsType;
import com.aliyun.odps.type.StructTypeInfo;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class SimpleStructTypeInfo
implements StructTypeInfo {
    private static final long serialVersionUID = 1L;
    private final List<String> fieldNames;
    private final List<TypeInfo> fieldTypeInfos;

    SimpleStructTypeInfo(List<String> names, List<TypeInfo> typeInfos) {
        this.validateParameters(names, typeInfos);
        this.fieldNames = StringUtils.toLowerCase(names);
        this.fieldTypeInfos = new ArrayList<TypeInfo>(typeInfos);
    }

    private void validateParameters(List<String> names, List<TypeInfo> typeInfos) {
        if (names == null || typeInfos == null || names.isEmpty() || typeInfos.isEmpty()) {
            throw new IllegalArgumentException("Invalid name or element type for struct.");
        }
        if (names.size() != typeInfos.size()) {
            throw new IllegalArgumentException("The amount of field names must be equal to the amount of field types.");
        }
    }

    @Override
    public String getTypeName() {
        StringBuilder stringBuilder = new StringBuilder(this.getOdpsType().name());
        stringBuilder.append("<");
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("`").append(this.fieldNames.get(i)).append("`");
            stringBuilder.append(":");
            stringBuilder.append(this.fieldTypeInfos.get(i).getTypeName());
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    @Override
    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public List<TypeInfo> getFieldTypeInfos() {
        return this.fieldTypeInfos;
    }

    @Override
    public int getFieldCount() {
        return this.fieldNames.size();
    }

    @Override
    public OdpsType getOdpsType() {
        return OdpsType.STRUCT;
    }

    public String toString() {
        return this.getTypeName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleStructTypeInfo that = (SimpleStructTypeInfo)o;
        return StringUtils.equalsIgnoreCase(this.fieldNames, that.fieldNames) && Objects.equals(this.fieldTypeInfos, that.fieldTypeInfos);
    }

    public int hashCode() {
        return Objects.hash(StringUtils.toLowerCase(this.fieldNames), this.fieldTypeInfos);
    }
}

