/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.profile;

import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.Credential;
import com.aliyuncs.auth.CredentialsBackupCompatibilityAdaptor;
import com.aliyuncs.auth.ICredentialProvider;
import com.aliyuncs.auth.ISigner;
import com.aliyuncs.endpoint.DefaultEndpointResolver;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.profile.IClientProfile;

public class DefaultProfile
implements IClientProfile {
    private static DefaultProfile profile = null;
    private String regionId = null;
    private FormatType acceptFormat = null;
    private ICredentialProvider icredential = null;
    private Credential credential;
    private String certPath;
    private HttpClientConfig httpClientConfig = HttpClientConfig.getDefault();
    private boolean usingInternalLocationService = false;

    private DefaultProfile() {
    }

    private DefaultProfile(String regionId) {
        this.regionId = regionId;
    }

    private DefaultProfile(String regionId, Credential creden) {
        this.credential = creden;
        this.regionId = regionId;
    }

    private DefaultProfile(ICredentialProvider icredential) {
        this.icredential = icredential;
    }

    private DefaultProfile(String region, ICredentialProvider icredential) {
        this.regionId = region;
        this.icredential = icredential;
    }

    private DefaultProfile(ICredentialProvider icredential, String region, FormatType format) {
        this.regionId = region;
        this.acceptFormat = format;
        this.icredential = icredential;
    }

    public static synchronized DefaultProfile getProfile() {
        if (null == profile) {
            profile = new DefaultProfile();
        }
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId, ICredentialProvider icredential) {
        profile = new DefaultProfile(regionId, icredential);
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId, String accessKeyId, String secret) {
        Credential creden = new Credential(accessKeyId, secret);
        profile = new DefaultProfile(regionId, creden);
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId, String accessKeyId, String secret, String stsToken) {
        Credential creden = new Credential(accessKeyId, secret, stsToken);
        profile = new DefaultProfile(regionId, creden);
        return profile;
    }

    public static synchronized DefaultProfile getProfile(String regionId) {
        return new DefaultProfile(regionId);
    }

    @Deprecated
    public static synchronized void addEndpoint(String endpointName, String regionId, String product, String domain) throws ClientException {
        DefaultProfile.addEndpoint(endpointName, regionId, product, domain, true);
    }

    @Deprecated
    public static synchronized void addEndpoint(String endpointName, String regionId, String product, String domain, boolean isNeverExpire) {
        DefaultProfile.addEndpoint(regionId, product, domain);
    }

    public static synchronized void addEndpoint(String regionId, String product, String endpoint) {
        DefaultEndpointResolver.predefinedEndpointResolver.putEndpointEntry(regionId, product, endpoint);
    }

    @Override
    public synchronized String getRegionId() {
        return this.regionId;
    }

    @Override
    public synchronized FormatType getFormat() {
        return this.acceptFormat;
    }

    @Override
    public synchronized Credential getCredential() {
        if (null == this.credential && null != this.icredential) {
            this.credential = this.icredential.fresh();
        }
        return this.credential;
    }

    @Override
    @Deprecated
    public ISigner getSigner() {
        return null;
    }

    @Override
    public void setCredentialsProvider(AlibabaCloudCredentialsProvider credentialsProvider) {
        if (this.credential != null) {
            return;
        }
        this.credential = new CredentialsBackupCompatibilityAdaptor(credentialsProvider);
    }

    @Override
    public String getCertPath() {
        return this.certPath;
    }

    @Override
    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    @Override
    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    @Override
    public void setHttpClientConfig(HttpClientConfig httpClientConfig) {
        this.httpClientConfig = httpClientConfig;
    }

    @Override
    public void setUsingInternalLocationService() {
        this.usingInternalLocationService = true;
    }

    @Override
    public boolean isUsingInternalLocationService() {
        return this.usingInternalLocationService;
    }
}

