/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.dubbo.wrapper;

import java.io.IOException;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.Codec2;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.Response;
import org.apache.dubbo.rpc.AppResponse;
import org.apache.dubbo.rpc.RpcInvocation;

public class DataSizeCodecWrapper
implements Codec2 {
    protected Codec2 codec;

    public DataSizeCodecWrapper(Codec2 codec) {
        this.codec = codec;
    }

    public void encode(Channel channel, ChannelBuffer buffer, Object message) throws IOException {
        Object response;
        if (message instanceof Request) {
            Object data = ((Request)message).getData();
            if (data instanceof RpcInvocation) {
                RpcInvocation invocation = (RpcInvocation)data;
                this.encodeRequestWithTracer(channel, buffer, message, invocation);
                return;
            }
        } else if (message instanceof Response && (response = ((Response)message).getResult()) instanceof AppResponse) {
            this.encodeResultWithTracer(channel, buffer, message);
            return;
        }
        this.codec.encode(channel, buffer, message);
    }

    protected void encodeRequestWithTracer(Channel channel, ChannelBuffer buffer, Object message, RpcInvocation invocation) throws IOException {
        long startTime = System.currentTimeMillis();
        int index = buffer.writerIndex();
        this.codec.encode(channel, buffer, message);
        int reqSize = buffer.writerIndex() - index;
        long elapsed = System.currentTimeMillis() - startTime;
        invocation.setAttachment("client.serialize.size", String.valueOf(reqSize));
        invocation.setAttachment("client.serialize.time", String.valueOf(elapsed));
    }

    protected void encodeResultWithTracer(Channel channel, ChannelBuffer buffer, Object message) throws IOException {
        Object result = ((Response)message).getResult();
        long startTime = System.currentTimeMillis();
        int index = buffer.writerIndex();
        this.codec.encode(channel, buffer, message);
        int respSize = buffer.writerIndex() - index;
        long elapsed = System.currentTimeMillis() - startTime;
        ((AppResponse)result).setAttachment("server.serialize.size", String.valueOf(respSize));
        ((AppResponse)result).setAttachment("server.serialize.time", String.valueOf(elapsed));
    }

    public Object decode(Channel channel, ChannelBuffer input) throws IOException {
        Object result;
        long startTime = System.currentTimeMillis();
        int index = input.readerIndex();
        Object ret = this.codec.decode(channel, input);
        int size = input.readerIndex() - index;
        long elapsed = System.currentTimeMillis() - startTime;
        if (ret instanceof Request) {
            Object data = ((Request)ret).getData();
            if (data instanceof RpcInvocation) {
                RpcInvocation invocation = (RpcInvocation)data;
                invocation.setAttachment("server.deserialize.size", String.valueOf(size));
                invocation.setAttachment("server.deserialize.time", String.valueOf(elapsed));
            }
        } else if (ret instanceof Response && (result = ((Response)ret).getResult()) instanceof AppResponse) {
            AppResponse rpcResult = (AppResponse)result;
            rpcResult.setAttachment("client.deserialize.size", String.valueOf(size));
            rpcResult.setAttachment("client.deserialize.time", String.valueOf(elapsed));
        }
        return ret;
    }
}

