/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.dubbo.tracer;

import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.tracer.AbstractServerTracer;
import com.alipay.sofa.tracer.plugins.dubbo.encoder.DubboServerDigestEncoder;
import com.alipay.sofa.tracer.plugins.dubbo.encoder.DubboServerDigestJsonEncoder;
import com.alipay.sofa.tracer.plugins.dubbo.enums.DubboLogEnum;
import com.alipay.sofa.tracer.plugins.dubbo.stat.DubboServerStatJsonReporter;
import com.alipay.sofa.tracer.plugins.dubbo.stat.DubboServerStatReporter;

public class DubboProviderSofaTracer
extends AbstractServerTracer {
    private static volatile DubboProviderSofaTracer dubboProviderSofaTracer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DubboProviderSofaTracer getDubboProviderSofaTracerSingleton() {
        if (dubboProviderSofaTracer != null) return dubboProviderSofaTracer;
        Class<DubboProviderSofaTracer> clazz = DubboProviderSofaTracer.class;
        synchronized (DubboProviderSofaTracer.class) {
            if (dubboProviderSofaTracer != null) return dubboProviderSofaTracer;
            dubboProviderSofaTracer = new DubboProviderSofaTracer("dubbo-server");
            // ** MonitorExit[var0] (shouldn't be in output)
            return dubboProviderSofaTracer;
        }
    }

    public DubboProviderSofaTracer(String tracerType) {
        super(tracerType);
    }

    protected String getServerDigestReporterLogName() {
        return DubboLogEnum.DUBBO_SERVER_DIGEST.getDefaultLogName();
    }

    protected String getServerDigestReporterRollingKey() {
        return DubboLogEnum.DUBBO_SERVER_DIGEST.getRollingKey();
    }

    protected String getServerDigestReporterLogNameKey() {
        return DubboLogEnum.DUBBO_SERVER_DIGEST.getLogNameKey();
    }

    protected SpanEncoder<SofaTracerSpan> getServerDigestEncoder() {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new DubboServerDigestJsonEncoder();
        }
        return new DubboServerDigestEncoder();
    }

    protected AbstractSofaTracerStatisticReporter generateServerStatReporter() {
        DubboLogEnum dubboClientStat = DubboLogEnum.DUBBO_SERVER_STAT;
        String statLog = dubboClientStat.getDefaultLogName();
        String statRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)dubboClientStat.getRollingKey());
        String statLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)dubboClientStat.getLogNameKey());
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new DubboServerStatJsonReporter(statLog, statRollingPolicy, statLogReserveConfig);
        }
        return new DubboServerStatReporter(statLog, statRollingPolicy, statLogReserveConfig);
    }
}

