/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.dubbo.tracer;

import com.alipay.common.tracer.core.appender.encoder.SpanEncoder;
import com.alipay.common.tracer.core.configuration.SofaTracerConfiguration;
import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.tracer.AbstractClientTracer;
import com.alipay.sofa.tracer.plugins.dubbo.encoder.DubboClientDigestEncoder;
import com.alipay.sofa.tracer.plugins.dubbo.encoder.DubboClientDigestJsonEncoder;
import com.alipay.sofa.tracer.plugins.dubbo.enums.DubboLogEnum;
import com.alipay.sofa.tracer.plugins.dubbo.stat.DubboClientStatJsonReporter;
import com.alipay.sofa.tracer.plugins.dubbo.stat.DubboClientStatReporter;

public class DubboConsumerSofaTracer
extends AbstractClientTracer {
    private static volatile DubboConsumerSofaTracer dubboConsumerSofaTracer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DubboConsumerSofaTracer getDubboConsumerSofaTracerSingleton() {
        if (dubboConsumerSofaTracer != null) return dubboConsumerSofaTracer;
        Class<DubboConsumerSofaTracer> clazz = DubboConsumerSofaTracer.class;
        synchronized (DubboConsumerSofaTracer.class) {
            if (dubboConsumerSofaTracer != null) return dubboConsumerSofaTracer;
            dubboConsumerSofaTracer = new DubboConsumerSofaTracer("dubbo-client");
            // ** MonitorExit[var0] (shouldn't be in output)
            return dubboConsumerSofaTracer;
        }
    }

    public DubboConsumerSofaTracer(String tracerType) {
        super(tracerType);
    }

    protected String getClientDigestReporterLogName() {
        return DubboLogEnum.DUBBO_CLIENT_DIGEST.getDefaultLogName();
    }

    protected String getClientDigestReporterRollingKey() {
        return DubboLogEnum.DUBBO_CLIENT_DIGEST.getRollingKey();
    }

    protected String getClientDigestReporterLogNameKey() {
        return DubboLogEnum.DUBBO_CLIENT_DIGEST.getLogNameKey();
    }

    protected SpanEncoder<SofaTracerSpan> getClientDigestEncoder() {
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new DubboClientDigestJsonEncoder();
        }
        return new DubboClientDigestEncoder();
    }

    protected AbstractSofaTracerStatisticReporter generateClientStatReporter() {
        DubboLogEnum dubboClientStat = DubboLogEnum.DUBBO_CLIENT_STAT;
        String statLog = dubboClientStat.getDefaultLogName();
        String statRollingPolicy = SofaTracerConfiguration.getRollingPolicy((String)dubboClientStat.getRollingKey());
        String statLogReserveConfig = SofaTracerConfiguration.getLogReserveConfig((String)dubboClientStat.getLogNameKey());
        if (SofaTracerConfiguration.isJsonOutput()) {
            return new DubboClientStatJsonReporter(statLog, statRollingPolicy, statLogReserveConfig);
        }
        return new DubboClientStatReporter(statLog, statRollingPolicy, statLogReserveConfig);
    }
}

