/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.dubbo.stat;

import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.TracerUtils;
import java.util.Map;

public class DubboServerStatReporter
extends AbstractSofaTracerStatisticReporter {
    public DubboServerStatReporter(String statTracerName, String rollingPolicy, String logReserveConfig) {
        super(statTracerName, rollingPolicy, logReserveConfig);
    }

    public void doReportStat(SofaTracerSpan sofaTracerSpan) {
        Map tagsWithStr = sofaTracerSpan.getTagsWithStr();
        StatKey statKey = new StatKey();
        String appName = (String)tagsWithStr.get("local.app");
        String serviceName = (String)tagsWithStr.get("service");
        String methodName = (String)tagsWithStr.get("method");
        statKey.setKey(this.buildString(new String[]{appName, serviceName, methodName}));
        String resultCode = (String)tagsWithStr.get("result.code");
        statKey.setResult("00".equals(resultCode) ? "Y" : "N");
        statKey.setEnd(this.buildString(new String[]{TracerUtils.getLoadTestMark((SofaTracerSpan)sofaTracerSpan)}));
        statKey.setLoadTest(TracerUtils.isLoadTest((SofaTracerSpan)sofaTracerSpan));
        long duration = sofaTracerSpan.getEndTime() - sofaTracerSpan.getStartTime();
        long[] values = new long[]{1L, duration};
        this.addStat(statKey, values);
    }
}

