/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.dubbo.stat;

import com.alipay.common.tracer.core.reporter.stat.AbstractSofaTracerStatisticReporter;
import com.alipay.common.tracer.core.reporter.stat.model.StatKey;
import com.alipay.common.tracer.core.reporter.stat.model.StatMapKey;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.TracerUtils;
import java.util.Map;

public class DubboServerStatJsonReporter
extends AbstractSofaTracerStatisticReporter {
    public DubboServerStatJsonReporter(String statTracerName, String rollingPolicy, String logReserveConfig) {
        super(statTracerName, rollingPolicy, logReserveConfig);
    }

    public void doReportStat(SofaTracerSpan sofaTracerSpan) {
        Map tagsWithStr = sofaTracerSpan.getTagsWithStr();
        StatMapKey statKey = new StatMapKey();
        String appName = (String)tagsWithStr.get("local.app");
        String serviceName = (String)tagsWithStr.get("service");
        String methodName = (String)tagsWithStr.get("method");
        statKey.addKey("local.app", appName);
        statKey.addKey("service", serviceName);
        statKey.addKey("method", methodName);
        String resultCode = (String)tagsWithStr.get("result.code");
        statKey.setResult("00".equals(resultCode) ? "Y" : "N");
        statKey.setEnd(this.buildString(new String[]{this.getLoadTestMark(sofaTracerSpan)}));
        statKey.setLoadTest(TracerUtils.isLoadTest((SofaTracerSpan)sofaTracerSpan));
        long duration = sofaTracerSpan.getEndTime() - sofaTracerSpan.getStartTime();
        long[] values = new long[]{1L, duration};
        this.addStat((StatKey)statKey, values);
    }

    protected String getLoadTestMark(SofaTracerSpan span) {
        if (TracerUtils.isLoadTest((SofaTracerSpan)span)) {
            return "T";
        }
        return "F";
    }
}

