/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.dubbo.encoder;

import com.alipay.common.tracer.core.appender.builder.JsonStringBuilder;
import com.alipay.common.tracer.core.appender.builder.XStringBuilder;
import com.alipay.common.tracer.core.middleware.parent.AbstractDigestSpanEncoder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import io.opentracing.tag.Tags;
import java.util.Map;

public class DubboServerDigestJsonEncoder
extends AbstractDigestSpanEncoder {
    protected void appendComponentSlot(XStringBuilder xsb, JsonStringBuilder jsb, SofaTracerSpan span) {
        Map tagStr = span.getTagsWithStr();
        Map tagNum = span.getTagsWithNumber();
        jsb.append("protocol", tagStr.get("protocol"));
        jsb.append("service", tagStr.get("service"));
        jsb.append("method", tagStr.get("method"));
        jsb.append("local.host", tagStr.get("local.host"));
        jsb.append("local.port", tagStr.get("local.port"));
        long serializeTime = this.getTime((Number)tagNum.get("server.serialize.time"));
        jsb.append("server.serialize.time", (Object)serializeTime);
        long deserializeTime = this.getTime((Number)tagNum.get("server.deserialize.time"));
        jsb.append("server.deserialize.time", (Object)deserializeTime);
        Number reqSizeNum = (Number)tagNum.get("server.deserialize.size");
        jsb.append("req.size.bytes", (Object)(reqSizeNum == null ? 0L : reqSizeNum.longValue()));
        Number respSizeNum = (Number)tagNum.get("server.serialize.size");
        jsb.append("resp.size.bytes", (Object)(respSizeNum == null ? 0L : respSizeNum.longValue()));
        if (StringUtils.isNotBlank((String)((String)tagStr.get(Tags.ERROR.getKey())))) {
            jsb.append(Tags.ERROR.getKey(), tagStr.get(Tags.ERROR.getKey()));
        } else {
            jsb.append(Tags.ERROR.getKey(), (Object)"");
        }
    }

    private long getTime(Number number) {
        if (number != null) {
            return number.longValue();
        }
        return 0L;
    }
}

