/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.dubbo.encoder;

import com.alipay.common.tracer.core.appender.builder.JsonStringBuilder;
import com.alipay.common.tracer.core.appender.builder.XStringBuilder;
import com.alipay.common.tracer.core.middleware.parent.AbstractDigestSpanEncoder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import io.opentracing.tag.Tags;
import java.util.Map;

public class DubboServerDigestEncoder
extends AbstractDigestSpanEncoder {
    protected void appendComponentSlot(XStringBuilder xsb, JsonStringBuilder jsb, SofaTracerSpan span) {
        Map tagWithStr = span.getTagsWithStr();
        Map tagWithNum = span.getTagsWithNumber();
        xsb.append((String)tagWithStr.get("protocol"));
        xsb.append((String)tagWithStr.get("service"));
        xsb.append((String)tagWithStr.get("method"));
        xsb.append((String)tagWithStr.get("invoke.type"));
        xsb.append((String)tagWithStr.get("remote.host"));
        xsb.append((String)tagWithStr.get("remote.port"));
        xsb.append((String)tagWithStr.get("local.host"));
        xsb.append(tagWithNum.get("client.serialize.time") + "");
        xsb.append(tagWithNum.get("client.deserialize.time") + "");
        long serializeTime = this.getTime((Number)tagWithNum.get("server.serialize.time"));
        long deserializeTime = this.getTime((Number)tagWithNum.get("server.deserialize.time"));
        xsb.append(String.valueOf(serializeTime));
        xsb.append(String.valueOf(deserializeTime));
        Number reqSizeNum = (Number)tagWithNum.get("server.deserialize.size");
        xsb.append(reqSizeNum == null ? 0L : reqSizeNum.longValue());
        Number respSizeNum = (Number)tagWithNum.get("server.serialize.size");
        xsb.append(respSizeNum == null ? 0L : respSizeNum.longValue());
        xsb.append(StringUtils.isBlank((String)((String)tagWithStr.get(Tags.ERROR.getKey()))) ? "" : (String)tagWithStr.get(Tags.ERROR.getKey()));
    }

    private long getTime(Number number) {
        if (number != null) {
            return number.longValue();
        }
        return 0L;
    }
}

