/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.tracer.plugins.dubbo.encoder;

import com.alipay.common.tracer.core.appender.builder.JsonStringBuilder;
import com.alipay.common.tracer.core.appender.builder.XStringBuilder;
import com.alipay.common.tracer.core.middleware.parent.AbstractDigestSpanEncoder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.StringUtils;
import io.opentracing.tag.Tags;
import java.util.Map;

public class DubboClientDigestJsonEncoder
extends AbstractDigestSpanEncoder {
    protected void appendComponentSlot(XStringBuilder xsb, JsonStringBuilder jsb, SofaTracerSpan span) {
        Map tagStr = span.getTagsWithStr();
        Map tagNum = span.getTagsWithNumber();
        jsb.append("protocol", tagStr.get("protocol"));
        jsb.append("service", tagStr.get("service"));
        jsb.append("method", tagStr.get("method"));
        jsb.append("invoke.type", tagStr.get("invoke.type"));
        jsb.append("remote.host", tagStr.get("remote.host"));
        jsb.append("remote.port", tagStr.get("remote.port"));
        jsb.append("local.host", tagStr.get("local.host"));
        jsb.append("client.serialize.time", tagNum.get("client.serialize.time"));
        jsb.append("client.deserialize.time", tagNum.get("client.deserialize.time"));
        Number reqSizeNum = (Number)tagNum.get("client.serialize.size");
        jsb.append("req.size.bytes", (Object)(reqSizeNum == null ? 0L : reqSizeNum.longValue()));
        Number respSizeNum = (Number)tagNum.get("client.deserialize.size");
        jsb.append("resp.size.bytes", (Object)(respSizeNum == null ? 0L : respSizeNum.longValue()));
        if (StringUtils.isNotBlank((String)((String)tagStr.get(Tags.ERROR.getKey())))) {
            jsb.append(Tags.ERROR.getKey(), tagStr.get(Tags.ERROR.getKey()));
        } else {
            jsb.append(Tags.ERROR.getKey(), (Object)"");
        }
    }
}

